package io.springboot.plugin.gemini;

import io.springboot.plugin.gemini.client.GeminiClient;
import io.springboot.plugin.gemini.properties.GeminiProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(GeminiProperties.class)
public class GeminiConfiguration {

    @Bean
    public GeminiClient geminiClient(GeminiProperties geminiProperties) {
        return new GeminiClient(geminiProperties.getApiKey(), geminiProperties.getProxyHost(), geminiProperties.getProxyPort());
    }


}
