/*
 * Decompiled with CFR 0.152.
 */
package io.springboot.plugin.gemini.pojo;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import javax.imageio.ImageIO;

public class Generate {
    public static Request creatTextChart(String text) {
        Request request = new Request();
        Request.Chat chat = new Request.Chat();
        chat.setRole("user");
        chat.getParts().add(new Request.TextPart(text));
        request.getContents().add(chat);
        request.vision = false;
        return request;
    }

    public static Request creatImageChart(String text, File image) throws IOException {
        Request request = new Request();
        Request.Chat chat = new Request.Chat();
        chat.getParts().add(new Request.TextPart(text));
        chat.getParts().add(new Request.ImagePart(image));
        request.getContents().add(chat);
        request.vision = true;
        return request;
    }

    public static String toAnswer(Response response) {
        if (response == null || response.getCandidates() == null || response.getCandidates().isEmpty()) {
            return null;
        }
        return response.getCandidates().get(0).getAnswer();
    }

    public static class Request {
        private List<Chat> contents = new ArrayList<Chat>();
        @JSONField(serialize=false)
        private boolean vision;

        public String toJSONString() {
            return JSONObject.toJSONString((Object)this);
        }

        public void setContents(List<Chat> contents) {
            this.contents = contents;
        }

        public void setVision(boolean vision) {
            this.vision = vision;
        }

        public List<Chat> getContents() {
            return this.contents;
        }

        public boolean isVision() {
            return this.vision;
        }

        public static class Chat {
            private String role;
            private List<Part> parts = new ArrayList<Part>();

            public void setRole(String role) {
                this.role = role;
            }

            public void setParts(List<Part> parts) {
                this.parts = parts;
            }

            public String getRole() {
                return this.role;
            }

            public List<Part> getParts() {
                return this.parts;
            }
        }

        public static class InlineData {
            @JSONField(name="mime_type")
            private String mimeType;
            private String data;

            public void setMimeType(String mimeType) {
                this.mimeType = mimeType;
            }

            public void setData(String data) {
                this.data = data;
            }

            public String getMimeType() {
                return this.mimeType;
            }

            public String getData() {
                return this.data;
            }
        }

        public static class ImagePart
        extends Part {
            @JSONField(name="inline_data")
            private InlineData inlineData = new InlineData();

            public ImagePart(File file) throws IOException {
                BufferedImage bufferedImage = ImageIO.read(file);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                String formatName = ImageIO.getImageReaders(ImageIO.createImageInputStream(file)).next().getFormatName();
                ImageIO.write((RenderedImage)bufferedImage, formatName, outputStream);
                String base64 = Base64.getEncoder().encodeToString(outputStream.toByteArray());
                this.inlineData.setData(base64);
                String mimeType = URLConnection.guessContentTypeFromName(file.getName());
                this.inlineData.setMimeType(mimeType);
            }

            public void setInlineData(InlineData inlineData) {
                this.inlineData = inlineData;
            }

            public InlineData getInlineData() {
                return this.inlineData;
            }
        }

        public static class TextPart
        extends Part {
            private String text;

            public TextPart(String text) {
                this.text = text;
            }

            public void setText(String text) {
                this.text = text;
            }

            public String getText() {
                return this.text;
            }
        }

        public static class Part {
        }
    }

    public static class Response {
        private List<Candidate> candidates;
        private PromptFeedback promptFeedback;

        public void setCandidates(List<Candidate> candidates) {
            this.candidates = candidates;
        }

        public void setPromptFeedback(PromptFeedback promptFeedback) {
            this.promptFeedback = promptFeedback;
        }

        public List<Candidate> getCandidates() {
            return this.candidates;
        }

        public PromptFeedback getPromptFeedback() {
            return this.promptFeedback;
        }

        public static class PromptFeedback {
            private List<SafetyRating> safetyRatings;

            public void setSafetyRatings(List<SafetyRating> safetyRatings) {
                this.safetyRatings = safetyRatings;
            }

            public List<SafetyRating> getSafetyRatings() {
                return this.safetyRatings;
            }
        }

        public static class SafetyRating {
            private String category;
            private String probability;

            public void setCategory(String category) {
                this.category = category;
            }

            public void setProbability(String probability) {
                this.probability = probability;
            }

            public String getCategory() {
                return this.category;
            }

            public String getProbability() {
                return this.probability;
            }
        }

        public static class Part {
            private String text;

            public void setText(String text) {
                this.text = text;
            }

            public String getText() {
                return this.text;
            }
        }

        public static class Content {
            private List<Part> parts;
            private String role;

            public void setParts(List<Part> parts) {
                this.parts = parts;
            }

            public void setRole(String role) {
                this.role = role;
            }

            public List<Part> getParts() {
                return this.parts;
            }

            public String getRole() {
                return this.role;
            }
        }

        public static class Candidate {
            private Content content;
            private String finishReason;
            private int index;
            private List<SafetyRating> safetyRatings;

            public String getAnswer() {
                if (this.content == null || this.content.getParts() == null || this.content.getParts().isEmpty()) {
                    return null;
                }
                return this.content.getParts().get(0).getText();
            }

            public void setContent(Content content) {
                this.content = content;
            }

            public void setFinishReason(String finishReason) {
                this.finishReason = finishReason;
            }

            public void setIndex(int index) {
                this.index = index;
            }

            public void setSafetyRatings(List<SafetyRating> safetyRatings) {
                this.safetyRatings = safetyRatings;
            }

            public Content getContent() {
                return this.content;
            }

            public String getFinishReason() {
                return this.finishReason;
            }

            public int getIndex() {
                return this.index;
            }

            public List<SafetyRating> getSafetyRatings() {
                return this.safetyRatings;
            }
        }
    }
}

