/*
 * Decompiled with CFR 0.152.
 */
package io.springboot.plugin.gemini.client;

import com.alibaba.fastjson.JSONObject;
import io.springboot.plugin.gemini.pojo.Embedding;
import io.springboot.plugin.gemini.pojo.Generate;
import java.net.InetSocketAddress;
import java.net.Proxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class GeminiClient {
    private static final Logger log = LoggerFactory.getLogger(GeminiClient.class);
    private final RestTemplate restTemplate;
    private final String apiKey;
    private static final String baseUrl = "https://generativelanguage.googleapis.com/v1beta/";
    private final HttpHeaders headers;

    public GeminiClient(String apiKey, String proxyHost, int proxyPort) {
        this.apiKey = apiKey;
        this.restTemplate = new RestTemplate();
        this.headers = new HttpHeaders();
        this.headers.add("Content-Type", "application/json");
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setConnectTimeout(3000);
        if (StringUtils.hasLength((String)proxyHost) && proxyPort > 0) {
            requestFactory.setProxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort)));
        }
        this.restTemplate.setRequestFactory((ClientHttpRequestFactory)requestFactory);
    }

    public Generate.Response generate(Generate.Request request) {
        String url = request.isVision() ? "https://generativelanguage.googleapis.com/v1beta/models/gemini-pro-vision:generateContent?key=" + this.apiKey : "https://generativelanguage.googleapis.com/v1beta/models/gemini-pro:generateContent?key=" + this.apiKey;
        String json = request.toJSONString();
        log.debug("json:{}", (Object)json);
        HttpEntity httpEntity = new HttpEntity((Object)json, (MultiValueMap)this.headers);
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, String.class, new Object[0]);
        return (Generate.Response)JSONObject.parseObject((String)((String)response.getBody()), Generate.Response.class);
    }

    public Embedding.Response embedding(Embedding.Request request) {
        String url = "https://generativelanguage.googleapis.com/v1beta/models//embedding-001:embedContent?key=" + this.apiKey;
        String json = request.toJSONString();
        log.debug("json:{}", (Object)json);
        HttpEntity httpEntity = new HttpEntity((Object)json, (MultiValueMap)this.headers);
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, String.class, new Object[0]);
        return (Embedding.Response)JSONObject.parseObject((String)((String)response.getBody()), Embedding.Response.class);
    }
}

