package io.springboot.plugin.dashscope.endpoint;

import com.alibaba.dashscope.aigc.generation.Generation;
import com.alibaba.dashscope.aigc.generation.models.QwenParam;
import com.alibaba.dashscope.utils.Constants;
import io.springboot.plugin.dashscope.config.DashscopeProperties;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

/**
 * 灵积接口
 *
 * @author lengleng
 * @date 2023/12/13
 */
@Slf4j
@RestController
@RequiredArgsConstructor
@RequestMapping("/chat")
public class DashscopeEndpoint {

    private final DashscopeProperties dashscopeProperties;

    @PostMapping(value = "/msg")
    public String msg(@RequestBody Map<String, String> request) {
        Generation gen = new Generation();
        QwenParam params = QwenParam.builder().model(dashscopeProperties.getModel())
                .prompt(request.get("content"))
                .seed(dashscopeProperties.getSeed())
                .topP(dashscopeProperties.getTopP())
                .resultFormat(dashscopeProperties.getResultFormat())
                .enableSearch(dashscopeProperties.isEnableSearch())
                .maxTokens(dashscopeProperties.getMaxTokens())
                .temperature(dashscopeProperties.getTemperature())
                .repetitionPenalty(dashscopeProperties.getRepetitionPenalty())
                .build();
        try {
            return gen.call(params).getOutput().getText();
        } catch (Exception e) {
            log.error("调用灵积异常 {}", e.getMessage());
        }
        return "";
    }
}
