package io.springboot.plugin.dashscope.config;

import com.alibaba.dashscope.utils.Constants;
import lombok.Data;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * @author lengleng
 * @date 2023/12/13
 */
@Data
@Component
@ConfigurationProperties(prefix = "dashscope")
public class DashscopeProperties implements InitializingBean {
    /**
     * DashScope API-KEY
     */
    private String apiKey;
    /**
     * 指明需要调用的模型
     */
    private String model = "qwen-max";
    /**
     * 生成时，随机数的种子，用于控制模型生成的随机性
     */
    private int seed = 1234;
    /**
     * 生成过程中核采样方法概率阈值
     */
    private double topP = 0.8;
    /**
     * [text|message],默认为text，当为message时，输出参考message结果示例。推荐优先使用message格式
     */
    private String resultFormat = "text";
    /**
     * 生成时，是否参考搜索的结果
     */
    private boolean enableSearch = false;
    /**
     * 用于限制模型生成token的数量
     */
    private int maxTokens = 1500;
    /**
     * 用于控制随机性和多样性的程度
     */
    private float temperature = 1.0f;
    /**
     * 用于控制模型生成时的重复度
     */
    private float repetitionPenalty = 1.1f;

    /**
     * 初始化key
     *
     * @throws Exception
     */
    @Override
    public void afterPropertiesSet() throws Exception {
        Constants.apiKey = this.apiKey;
    }
}
