package io.springboot.plugin.dashscope;

import io.springboot.plugin.dashscope.config.DashscopeProperties;
import io.springboot.plugin.dashscope.endpoint.DashscopeEndpoint;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

/**
 * @author lengleng
 * @date 2023/12/13
 */
@AutoConfiguration
@EnableConfigurationProperties(DashscopeProperties.class)
public class DashscopeAutoConfiguration {

    @Bean
    public DashscopeEndpoint dashscopeEndpoint(DashscopeProperties dashscopeProperties) {
        return new DashscopeEndpoint(dashscopeProperties);
    }
}
