/*
 * Decompiled with CFR 0.152.
 */
package io.springboot.plugin.dashscope.config;

import com.alibaba.dashscope.utils.Constants;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="dashscope")
public class DashscopeProperties
implements InitializingBean {
    private String apiKey;
    private String model = "qwen-max";
    private int seed = 1234;
    private double topP = 0.8;
    private String resultFormat = "message";
    private boolean enableSearch = false;
    private int maxTokens = 1500;
    private float temperature = 1.0f;
    private float repetitionPenalty = 1.1f;

    public void afterPropertiesSet() throws Exception {
        Constants.apiKey = this.apiKey;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getModel() {
        return this.model;
    }

    public int getSeed() {
        return this.seed;
    }

    public double getTopP() {
        return this.topP;
    }

    public String getResultFormat() {
        return this.resultFormat;
    }

    public boolean isEnableSearch() {
        return this.enableSearch;
    }

    public int getMaxTokens() {
        return this.maxTokens;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public float getRepetitionPenalty() {
        return this.repetitionPenalty;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setSeed(int seed) {
        this.seed = seed;
    }

    public void setTopP(double topP) {
        this.topP = topP;
    }

    public void setResultFormat(String resultFormat) {
        this.resultFormat = resultFormat;
    }

    public void setEnableSearch(boolean enableSearch) {
        this.enableSearch = enableSearch;
    }

    public void setMaxTokens(int maxTokens) {
        this.maxTokens = maxTokens;
    }

    public void setTemperature(float temperature) {
        this.temperature = temperature;
    }

    public void setRepetitionPenalty(float repetitionPenalty) {
        this.repetitionPenalty = repetitionPenalty;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DashscopeProperties)) {
            return false;
        }
        DashscopeProperties other = (DashscopeProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSeed() != other.getSeed()) {
            return false;
        }
        if (Double.compare(this.getTopP(), other.getTopP()) != 0) {
            return false;
        }
        if (this.isEnableSearch() != other.isEnableSearch()) {
            return false;
        }
        if (this.getMaxTokens() != other.getMaxTokens()) {
            return false;
        }
        if (Float.compare(this.getTemperature(), other.getTemperature()) != 0) {
            return false;
        }
        if (Float.compare(this.getRepetitionPenalty(), other.getRepetitionPenalty()) != 0) {
            return false;
        }
        String this$apiKey = this.getApiKey();
        String other$apiKey = other.getApiKey();
        if (this$apiKey == null ? other$apiKey != null : !this$apiKey.equals(other$apiKey)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        String this$resultFormat = this.getResultFormat();
        String other$resultFormat = other.getResultFormat();
        return !(this$resultFormat == null ? other$resultFormat != null : !this$resultFormat.equals(other$resultFormat));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DashscopeProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSeed();
        long $topP = Double.doubleToLongBits(this.getTopP());
        result = result * 59 + (int)($topP >>> 32 ^ $topP);
        result = result * 59 + (this.isEnableSearch() ? 79 : 97);
        result = result * 59 + this.getMaxTokens();
        result = result * 59 + Float.floatToIntBits(this.getTemperature());
        result = result * 59 + Float.floatToIntBits(this.getRepetitionPenalty());
        String $apiKey = this.getApiKey();
        result = result * 59 + ($apiKey == null ? 43 : $apiKey.hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        String $resultFormat = this.getResultFormat();
        result = result * 59 + ($resultFormat == null ? 43 : $resultFormat.hashCode());
        return result;
    }

    public String toString() {
        return "DashscopeProperties(apiKey=" + this.getApiKey() + ", model=" + this.getModel() + ", seed=" + this.getSeed() + ", topP=" + this.getTopP() + ", resultFormat=" + this.getResultFormat() + ", enableSearch=" + this.isEnableSearch() + ", maxTokens=" + this.getMaxTokens() + ", temperature=" + this.getTemperature() + ", repetitionPenalty=" + this.getRepetitionPenalty() + ")";
    }
}

