/*
 * Decompiled with CFR 0.152.
 */
package io.springboot.captcha.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;

public class FileUtil {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final int EOF = -1;

    public static void copyToFile(InputStream inputStream, File file) throws IOException {
        try (FileOutputStream out = FileUtil.openOutputStream(file);){
            FileUtil.copy(inputStream, out);
        }
    }

    public static FileOutputStream openOutputStream(File file) throws IOException {
        return FileUtil.openOutputStream(file, false);
    }

    public static FileOutputStream openOutputStream(File file, boolean append) throws IOException {
        Objects.requireNonNull(file, "file");
        if (file.exists()) {
            FileUtil.requireFile(file, "file");
            FileUtil.requireCanWrite(file, "file");
        } else {
            FileUtil.createParentDirectories(file);
        }
        return new FileOutputStream(file, append);
    }

    private static File requireFile(File file, String name) {
        Objects.requireNonNull(file, name);
        if (!file.isFile()) {
            throw new IllegalArgumentException("Parameter '" + name + "' is not a file: " + file);
        }
        return file;
    }

    private static void requireCanWrite(File file, String name) {
        Objects.requireNonNull(file, "file");
        if (!file.canWrite()) {
            throw new IllegalArgumentException("File parameter '" + name + " is not writable: '" + file + "'");
        }
    }

    public static File createParentDirectories(File file) throws IOException {
        return FileUtil.mkdirs(FileUtil.getParentFile(file));
    }

    private static File mkdirs(File directory) throws IOException {
        if (directory != null && !directory.mkdirs() && !directory.isDirectory()) {
            throw new IOException("Cannot create directory '" + directory + "'.");
        }
        return directory;
    }

    private static File getParentFile(File file) {
        return file == null ? null : file.getParentFile();
    }

    public static int copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        long count = FileUtil.copyLarge(inputStream, outputStream);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream) throws IOException {
        return FileUtil.copy(inputStream, outputStream, 8192);
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, int bufferSize) throws IOException {
        return FileUtil.copyLarge(inputStream, outputStream, FileUtil.byteArray(bufferSize));
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream, byte[] buffer) throws IOException {
        int n;
        Objects.requireNonNull(inputStream, "inputStream");
        Objects.requireNonNull(outputStream, "outputStream");
        long count = 0L;
        while (-1 != (n = inputStream.read(buffer))) {
            outputStream.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static byte[] byteArray(int size) {
        return new byte[size];
    }
}

