/*
 * Decompiled with CFR 0.152.
 */
package io.springboot.captcha.utils;

import io.springboot.captcha.SpecCaptcha;
import io.springboot.captcha.base.Captcha;
import io.springboot.captcha.utils.AbstractCaptchaUtil;
import java.awt.Font;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CaptchaUtil
extends AbstractCaptchaUtil {
    public static void out(HttpServletRequest request, HttpServletResponse response) throws IOException {
        CaptchaUtil.out(4, request, response);
    }

    public static void out(int len, HttpServletRequest request, HttpServletResponse response) throws IOException {
        CaptchaUtil.out(130, 48, len, request, response);
    }

    public static void out(int width, int height, int len, HttpServletRequest request, HttpServletResponse response) throws IOException {
        CaptchaUtil.out(width, height, len, null, 0, request, response);
    }

    public static void out(Font font, HttpServletRequest request, HttpServletResponse response) throws IOException {
        CaptchaUtil.out(130, 48, 4, font, 0, request, response);
    }

    public static void out(int len, Font font, HttpServletRequest request, HttpServletResponse response) throws IOException {
        CaptchaUtil.out(130, 48, len, font, 0, request, response);
    }

    public static void out(int width, int height, int len, Font font, int type, HttpServletRequest request, HttpServletResponse response) throws IOException {
        SpecCaptcha specCaptcha = new SpecCaptcha(width, height, len);
        if (font != null) {
            specCaptcha.setFont(font);
        }
        if (type > 0 && type <= 6) {
            specCaptcha.setCharType(type);
        }
        CaptchaUtil.out(specCaptcha, request, response);
    }

    public static void out(int width, int height, int len, int type, HttpServletRequest request, HttpServletResponse response) throws IOException {
        CaptchaUtil.out(width, height, len, null, type, request, response);
    }

    public static void out(Captcha captcha, HttpServletRequest request, HttpServletResponse response) throws IOException {
        CaptchaUtil.setHeader(response);
        request.getSession().setAttribute("captcha", (Object)captcha.text().toLowerCase());
        captcha.out((OutputStream)response.getOutputStream());
    }

    public static boolean ver(String code, HttpServletRequest request) {
        if (code != null) {
            String captcha = (String)request.getSession().getAttribute("captcha");
            return code.trim().toLowerCase().equals(captcha);
        }
        return false;
    }

    public static void clear(HttpServletRequest request) {
        request.getSession().removeAttribute("captcha");
    }

    public static void setHeader(HttpServletResponse response) {
        response.setContentType("image/gif");
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
    }
}

