/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.monitor;

import com.alibaba.nacos.common.utils.TopnCounterMetricsContainer;
import com.alibaba.nacos.core.monitor.NacosMeterRegistryCenter;
import com.alibaba.nacos.naming.core.v2.pojo.BatchInstancePublishInfo;
import com.alibaba.nacos.naming.core.v2.pojo.InstancePublishInfo;
import com.alibaba.nacos.naming.misc.Loggers;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.ImmutableTag;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class MetricsMonitor {
    private static final String METER_REGISTRY = "NAMING_STABLE_REGISTRY";
    private static final MetricsMonitor INSTANCE = new MetricsMonitor();
    private final AtomicInteger mysqlHealthCheck = new AtomicInteger();
    private final AtomicInteger httpHealthCheck = new AtomicInteger();
    private final AtomicInteger tcpHealthCheck = new AtomicInteger();
    private final AtomicInteger serviceCount = new AtomicInteger();
    private final AtomicInteger ipCount = new AtomicInteger();
    private final AtomicInteger subscriberCount = new AtomicInteger();
    private final AtomicLong maxPushCost = new AtomicLong(-1L);
    private final AtomicLong avgPushCost = new AtomicLong(-1L);
    private final AtomicLong leaderStatus = new AtomicLong();
    private final AtomicInteger totalPush = new AtomicInteger();
    private final AtomicInteger totalPushCountForAvg = new AtomicInteger();
    private final AtomicLong totalPushCostForAvg = new AtomicLong();
    private final AtomicInteger failedPush = new AtomicInteger();
    private final AtomicInteger emptyPush = new AtomicInteger();
    private final AtomicInteger serviceSubscribedEventQueueSize = new AtomicInteger();
    private final AtomicInteger serviceChangedEventQueueSize = new AtomicInteger();
    private final AtomicInteger pushPendingTaskCount = new AtomicInteger();
    private final ConcurrentHashMap<String, AtomicInteger> namingSubscriber = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, AtomicInteger> namingPublisher = new ConcurrentHashMap();
    private final TopnCounterMetricsContainer serviceChangeCount = new TopnCounterMetricsContainer();

    private MetricsMonitor() {
        for (Field each : MetricsMonitor.class.getDeclaredFields()) {
            if (!Number.class.isAssignableFrom(each.getType())) continue;
            each.setAccessible(true);
            try {
                this.registerToMetrics(each.getName(), (Number)each.get(this));
            }
            catch (IllegalAccessException e) {
                Loggers.PERFORMANCE_LOG.error("Init metrics for {} failed", (Object)each.getName(), (Object)e);
            }
        }
        this.namingSubscriber.put("v1", new AtomicInteger(0));
        this.namingSubscriber.put("v2", new AtomicInteger(0));
        ArrayList<ImmutableTag> tags = new ArrayList<ImmutableTag>();
        tags.add(new ImmutableTag("version", "v1"));
        NacosMeterRegistryCenter.gauge((String)METER_REGISTRY, (String)"nacos_naming_subscriber", tags, (Number)this.namingSubscriber.get("v1"));
        tags = new ArrayList();
        tags.add(new ImmutableTag("version", "v2"));
        NacosMeterRegistryCenter.gauge((String)METER_REGISTRY, (String)"nacos_naming_subscriber", tags, (Number)this.namingSubscriber.get("v2"));
        this.namingPublisher.put("v1", new AtomicInteger(0));
        this.namingPublisher.put("v2", new AtomicInteger(0));
        tags = new ArrayList();
        tags.add(new ImmutableTag("version", "v1"));
        NacosMeterRegistryCenter.gauge((String)METER_REGISTRY, (String)"nacos_naming_publisher", tags, (Number)this.namingPublisher.get("v1"));
        tags = new ArrayList();
        tags.add(new ImmutableTag("version", "v2"));
        NacosMeterRegistryCenter.gauge((String)METER_REGISTRY, (String)"nacos_naming_publisher", tags, (Number)this.namingPublisher.get("v2"));
    }

    private <T extends Number> void registerToMetrics(String name, T number) {
        ArrayList<ImmutableTag> tags = new ArrayList<ImmutableTag>();
        tags.add(new ImmutableTag("module", "naming"));
        tags.add(new ImmutableTag("name", name));
        NacosMeterRegistryCenter.gauge((String)METER_REGISTRY, (String)"nacos_monitor", tags, number);
    }

    public static AtomicInteger getMysqlHealthCheckMonitor() {
        return MetricsMonitor.INSTANCE.mysqlHealthCheck;
    }

    public static AtomicInteger getHttpHealthCheckMonitor() {
        return MetricsMonitor.INSTANCE.httpHealthCheck;
    }

    public static AtomicInteger getTcpHealthCheckMonitor() {
        return MetricsMonitor.INSTANCE.tcpHealthCheck;
    }

    public static AtomicInteger getDomCountMonitor() {
        return MetricsMonitor.INSTANCE.serviceCount;
    }

    public static AtomicInteger getIpCountMonitor() {
        return MetricsMonitor.INSTANCE.ipCount;
    }

    public static AtomicInteger getSubscriberCount() {
        return MetricsMonitor.INSTANCE.subscriberCount;
    }

    public static AtomicLong getMaxPushCostMonitor() {
        return MetricsMonitor.INSTANCE.maxPushCost;
    }

    public static AtomicLong getAvgPushCostMonitor() {
        return MetricsMonitor.INSTANCE.avgPushCost;
    }

    public static AtomicLong getLeaderStatusMonitor() {
        return MetricsMonitor.INSTANCE.leaderStatus;
    }

    public static AtomicInteger getTotalPushMonitor() {
        return MetricsMonitor.INSTANCE.totalPush;
    }

    public static AtomicInteger getFailedPushMonitor() {
        return MetricsMonitor.INSTANCE.failedPush;
    }

    public static AtomicInteger getEmptyPushMonitor() {
        return MetricsMonitor.INSTANCE.emptyPush;
    }

    public static AtomicInteger getTotalPushCountForAvg() {
        return MetricsMonitor.INSTANCE.totalPushCountForAvg;
    }

    public static AtomicInteger getServiceSubscribedEventQueueSize() {
        return MetricsMonitor.INSTANCE.serviceSubscribedEventQueueSize;
    }

    public static AtomicInteger getServiceChangedEventQueueSize() {
        return MetricsMonitor.INSTANCE.serviceChangedEventQueueSize;
    }

    public static AtomicInteger getPushPendingTaskCount() {
        return MetricsMonitor.INSTANCE.pushPendingTaskCount;
    }

    public static AtomicLong getTotalPushCostForAvg() {
        return MetricsMonitor.INSTANCE.totalPushCostForAvg;
    }

    public static AtomicInteger getNamingSubscriber(String version) {
        return MetricsMonitor.INSTANCE.namingSubscriber.get(version);
    }

    public static AtomicInteger getNamingPublisher(String version) {
        return MetricsMonitor.INSTANCE.namingPublisher.get(version);
    }

    public static TopnCounterMetricsContainer getServiceChangeCount() {
        return MetricsMonitor.INSTANCE.serviceChangeCount;
    }

    public static void compareAndSetMaxPushCost(long newCost) {
        MetricsMonitor.INSTANCE.maxPushCost.getAndUpdate(prev -> Math.max(newCost, prev));
    }

    public static void incrementPush() {
        MetricsMonitor.INSTANCE.totalPush.incrementAndGet();
    }

    public static void incrementPushCost(long costTime) {
        MetricsMonitor.INSTANCE.totalPushCountForAvg.incrementAndGet();
        MetricsMonitor.INSTANCE.totalPushCostForAvg.addAndGet(costTime);
    }

    public static void incrementFailPush() {
        MetricsMonitor.INSTANCE.failedPush.incrementAndGet();
    }

    public static void incrementEmptyPush() {
        MetricsMonitor.INSTANCE.emptyPush.incrementAndGet();
    }

    public static void incrementInstanceCount() {
        MetricsMonitor.INSTANCE.ipCount.incrementAndGet();
    }

    public static void decrementInstanceCount() {
        MetricsMonitor.INSTANCE.ipCount.decrementAndGet();
    }

    public static void incrementSubscribeCount() {
        MetricsMonitor.INSTANCE.subscriberCount.incrementAndGet();
    }

    public static void decrementSubscribeCount() {
        MetricsMonitor.INSTANCE.subscriberCount.decrementAndGet();
    }

    public static void incrementServiceChangeCount(String namespace, String group, String name) {
        MetricsMonitor.INSTANCE.serviceChangeCount.increment(namespace + "@" + group + "@" + name);
    }

    public static Counter getDiskException() {
        return NacosMeterRegistryCenter.counter((String)METER_REGISTRY, (String)"nacos_exception", (String[])new String[]{"module", "naming", "name", "disk"});
    }

    public static Counter getLeaderSendBeatFailedException() {
        return NacosMeterRegistryCenter.counter((String)METER_REGISTRY, (String)"nacos_exception", (String[])new String[]{"module", "naming", "name", "leaderSendBeatFailed"});
    }

    public static void incrementIpCountWithBatchRegister(InstancePublishInfo instancePublishInfo) {
        BatchInstancePublishInfo batchInstancePublishInfo = (BatchInstancePublishInfo)instancePublishInfo;
        List<InstancePublishInfo> instancePublishInfos = batchInstancePublishInfo.getInstancePublishInfos();
        MetricsMonitor.getIpCountMonitor().addAndGet(instancePublishInfos.size());
    }

    public static void decrementIpCountWithBatchRegister(InstancePublishInfo instancePublishInfo) {
        BatchInstancePublishInfo batchInstancePublishInfo = (BatchInstancePublishInfo)instancePublishInfo;
        List<InstancePublishInfo> instancePublishInfos = batchInstancePublishInfo.getInstancePublishInfos();
        MetricsMonitor.getIpCountMonitor().addAndGet(-1 * instancePublishInfos.size());
    }

    public static void resetAll() {
        MetricsMonitor.resetPush();
        MetricsMonitor.getHttpHealthCheckMonitor().set(0);
        MetricsMonitor.getMysqlHealthCheckMonitor().set(0);
        MetricsMonitor.getTcpHealthCheckMonitor().set(0);
    }

    public static void resetPush() {
        MetricsMonitor.getTotalPushMonitor().set(0);
        MetricsMonitor.getFailedPushMonitor().set(0);
        MetricsMonitor.getEmptyPushMonitor().set(0);
        MetricsMonitor.getTotalPushCostForAvg().set(0L);
        MetricsMonitor.getTotalPushCountForAvg().set(0);
        MetricsMonitor.getMaxPushCostMonitor().set(-1L);
        MetricsMonitor.getAvgPushCostMonitor().set(-1L);
    }
}

