/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.model.form;

import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.Objects;
import org.springframework.http.HttpStatus;

public class UpdateHealthForm {
    private Boolean healthy;
    private String groupName;
    private String serviceName;
    private String namespaceId;
    private String clusterName;
    private String ip;
    private Integer port;

    public void validate() throws NacosApiException {
        this.fillDefaultValue();
        if (this.healthy == null) {
            throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.PARAMETER_MISSING, "Required parameter 'healthy' type Boolean is not present");
        }
        if (StringUtils.isBlank((CharSequence)this.serviceName)) {
            throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.PARAMETER_MISSING, "Required parameter 'serviceName' type String is not present");
        }
        if (StringUtils.isBlank((CharSequence)this.ip)) {
            throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.PARAMETER_MISSING, "Required parameter 'ip' type String is not present");
        }
        if (this.port == null) {
            throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.PARAMETER_MISSING, "Required parameter 'port' type Integer is not present");
        }
    }

    public void fillDefaultValue() {
        if (StringUtils.isBlank((CharSequence)this.namespaceId)) {
            this.namespaceId = "public";
        }
        if (StringUtils.isBlank((CharSequence)this.groupName)) {
            this.groupName = "DEFAULT_GROUP";
        }
        if (StringUtils.isBlank((CharSequence)this.clusterName)) {
            this.clusterName = "DEFAULT";
        }
    }

    public Boolean getHealthy() {
        return this.healthy;
    }

    public void setHealthy(Boolean healthy) {
        this.healthy = healthy;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getNamespaceId() {
        return this.namespaceId;
    }

    public void setNamespaceId(String namespaceId) {
        this.namespaceId = namespaceId;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateHealthForm that = (UpdateHealthForm)o;
        return Objects.equals(this.healthy, that.healthy) && Objects.equals(this.groupName, that.groupName) && Objects.equals(this.serviceName, that.serviceName) && Objects.equals(this.namespaceId, that.namespaceId) && Objects.equals(this.clusterName, that.clusterName) && Objects.equals(this.ip, that.ip) && Objects.equals(this.port, that.port);
    }

    public int hashCode() {
        return Objects.hash(this.healthy, this.groupName, this.serviceName, this.namespaceId, this.clusterName, this.ip, this.port);
    }

    public String toString() {
        return "UpdateHealthForm{healthy=" + this.healthy + ", groupName='" + this.groupName + '\'' + ", serviceName='" + this.serviceName + '\'' + ", namespaceId='" + this.namespaceId + '\'' + ", clusterName='" + this.clusterName + '\'' + ", ip='" + this.ip + '\'' + ", port=" + this.port + '}';
    }
}

