/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.interceptor;

import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.naming.interceptor.Interceptable;
import com.alibaba.nacos.naming.interceptor.NacosNamingInterceptor;
import com.alibaba.nacos.naming.interceptor.NacosNamingInterceptorChain;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractNamingInterceptorChain<T extends Interceptable>
implements NacosNamingInterceptorChain<T> {
    private final List<NacosNamingInterceptor<T>> interceptors = new LinkedList<NacosNamingInterceptor<T>>();

    protected AbstractNamingInterceptorChain(Class<? extends NacosNamingInterceptor<T>> clazz) {
        this.interceptors.addAll(NacosServiceLoader.load(clazz));
        this.interceptors.sort(Comparator.comparingInt(NacosNamingInterceptor::order));
    }

    protected List<NacosNamingInterceptor<T>> getInterceptors() {
        return this.interceptors;
    }

    @Override
    public void addInterceptor(NacosNamingInterceptor<T> interceptor) {
        this.interceptors.add(interceptor);
        this.interceptors.sort(Comparator.comparingInt(NacosNamingInterceptor::order));
    }

    @Override
    public void doInterceptor(T object) {
        for (NacosNamingInterceptor<T> each : this.interceptors) {
            if (!each.isInterceptType(object.getClass()) || !each.intercept(object)) continue;
            object.afterIntercept();
            return;
        }
        object.passIntercept();
    }
}

