/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.healthcheck.v2.processor;

import com.alibaba.nacos.api.naming.pojo.healthcheck.HealthCheckType;
import com.alibaba.nacos.api.naming.pojo.healthcheck.impl.Http;
import com.alibaba.nacos.common.http.Callback;
import com.alibaba.nacos.common.http.HttpUtils;
import com.alibaba.nacos.common.http.client.NacosAsyncRestTemplate;
import com.alibaba.nacos.common.http.param.Header;
import com.alibaba.nacos.common.http.param.Query;
import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.naming.core.v2.metadata.ClusterMetadata;
import com.alibaba.nacos.naming.core.v2.pojo.HealthCheckInstancePublishInfo;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.healthcheck.v2.HealthCheckTaskV2;
import com.alibaba.nacos.naming.healthcheck.v2.processor.HealthCheckCommonV2;
import com.alibaba.nacos.naming.healthcheck.v2.processor.HealthCheckProcessorV2;
import com.alibaba.nacos.naming.misc.HttpClientManager;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import com.alibaba.nacos.naming.monitor.MetricsMonitor;
import java.net.ConnectException;
import java.net.URL;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class HttpHealthCheckProcessor
implements HealthCheckProcessorV2 {
    public static final String TYPE = HealthCheckType.HTTP.name();
    private static final NacosAsyncRestTemplate ASYNC_REST_TEMPLATE = HttpClientManager.getProcessorNacosAsyncRestTemplate();
    private final HealthCheckCommonV2 healthCheckCommon;
    private final SwitchDomain switchDomain;

    public HttpHealthCheckProcessor(HealthCheckCommonV2 healthCheckCommon, SwitchDomain switchDomain) {
        this.healthCheckCommon = healthCheckCommon;
        this.switchDomain = switchDomain;
    }

    @Override
    public void process(HealthCheckTaskV2 task, Service service, ClusterMetadata metadata) {
        HealthCheckInstancePublishInfo instance = (HealthCheckInstancePublishInfo)task.getClient().getInstancePublishInfo(service);
        if (null == instance) {
            return;
        }
        try {
            if (!instance.tryStartCheck()) {
                Loggers.SRV_LOG.warn("http check started before last one finished, service: {} : {} : {}:{}", new Object[]{service.getGroupedServiceName(), instance.getCluster(), instance.getIp(), instance.getPort()});
                this.healthCheckCommon.reEvaluateCheckRT(task.getCheckRtNormalized() * 2L, task, this.switchDomain.getHttpHealthParams());
                return;
            }
            Http healthChecker = (Http)metadata.getHealthChecker();
            int ckPort = metadata.isUseInstancePortForCheck() ? instance.getPort() : metadata.getHealthyCheckPort();
            URL host = new URL("http://" + instance.getIp() + ":" + ckPort);
            URL target = new URL(host, healthChecker.getPath());
            Map customHeaders = healthChecker.getCustomHeaders();
            Header header = Header.newInstance();
            header.addAll(customHeaders);
            ASYNC_REST_TEMPLATE.get(target.toString(), header, Query.EMPTY, String.class, (Callback)new HttpHealthCheckCallback(instance, task, service));
            MetricsMonitor.getHttpHealthCheckMonitor().incrementAndGet();
        }
        catch (Throwable e) {
            instance.setCheckRt(this.switchDomain.getHttpHealthParams().getMax());
            this.healthCheckCommon.checkFail(task, service, "http:error:" + e.getMessage());
            this.healthCheckCommon.reEvaluateCheckRT(this.switchDomain.getHttpHealthParams().getMax(), task, this.switchDomain.getHttpHealthParams());
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    private class HttpHealthCheckCallback
    implements Callback<String> {
        private final HealthCheckTaskV2 task;
        private final Service service;
        private final HealthCheckInstancePublishInfo instance;
        private long startTime = System.currentTimeMillis();

        public HttpHealthCheckCallback(HealthCheckInstancePublishInfo instance, HealthCheckTaskV2 task, Service service) {
            this.instance = instance;
            this.task = task;
            this.service = service;
        }

        public void onReceive(RestResult<String> result) {
            this.instance.setCheckRt(System.currentTimeMillis() - this.startTime);
            int httpCode = result.getCode();
            if (200 == httpCode) {
                HttpHealthCheckProcessor.this.healthCheckCommon.checkOk(this.task, this.service, "http:" + httpCode);
                HttpHealthCheckProcessor.this.healthCheckCommon.reEvaluateCheckRT(System.currentTimeMillis() - this.startTime, this.task, HttpHealthCheckProcessor.this.switchDomain.getHttpHealthParams());
            } else if (503 == httpCode || 302 == httpCode) {
                HttpHealthCheckProcessor.this.healthCheckCommon.checkFail(this.task, this.service, "http:" + httpCode);
                HttpHealthCheckProcessor.this.healthCheckCommon.reEvaluateCheckRT(this.task.getCheckRtNormalized() * 2L, this.task, HttpHealthCheckProcessor.this.switchDomain.getHttpHealthParams());
            } else {
                HttpHealthCheckProcessor.this.healthCheckCommon.checkFailNow(this.task, this.service, "http:" + httpCode);
                HttpHealthCheckProcessor.this.healthCheckCommon.reEvaluateCheckRT(HttpHealthCheckProcessor.this.switchDomain.getHttpHealthParams().getMax(), this.task, HttpHealthCheckProcessor.this.switchDomain.getHttpHealthParams());
            }
        }

        public void onError(Throwable throwable) {
            Throwable cause = throwable;
            this.instance.setCheckRt(System.currentTimeMillis() - this.startTime);
            int maxStackDepth = 50;
            for (int deepth = 0; deepth < maxStackDepth && cause != null; cause = cause.getCause(), ++deepth) {
                if (!HttpUtils.isTimeoutException((Throwable)cause)) continue;
                HttpHealthCheckProcessor.this.healthCheckCommon.checkFail(this.task, this.service, "http:" + cause.getMessage());
                HttpHealthCheckProcessor.this.healthCheckCommon.reEvaluateCheckRT(this.task.getCheckRtNormalized() * 2L, this.task, HttpHealthCheckProcessor.this.switchDomain.getHttpHealthParams());
                return;
            }
            if (throwable instanceof ConnectException) {
                HttpHealthCheckProcessor.this.healthCheckCommon.checkFailNow(this.task, this.service, "http:unable2connect:" + throwable.getMessage());
            } else {
                HttpHealthCheckProcessor.this.healthCheckCommon.checkFail(this.task, this.service, "http:error:" + throwable.getMessage());
            }
            HttpHealthCheckProcessor.this.healthCheckCommon.reEvaluateCheckRT(HttpHealthCheckProcessor.this.switchDomain.getHttpHealthParams().getMax(), this.task, HttpHealthCheckProcessor.this.switchDomain.getHttpHealthParams());
        }

        public void onCancel() {
        }
    }
}

