/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.controllers;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.api.selector.Selector;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.model.RestResultUtils;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.trace.event.naming.DeregisterServiceTraceEvent;
import com.alibaba.nacos.common.trace.event.naming.RegisterServiceTraceEvent;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.NumberUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.utils.WebUtils;
import com.alibaba.nacos.naming.core.ServiceOperator;
import com.alibaba.nacos.naming.core.ServiceOperatorV2Impl;
import com.alibaba.nacos.naming.core.SubscribeManager;
import com.alibaba.nacos.naming.core.v2.metadata.ServiceMetadata;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.UtilsAndCommons;
import com.alibaba.nacos.naming.pojo.Subscriber;
import com.alibaba.nacos.naming.selector.NoneSelector;
import com.alibaba.nacos.naming.selector.SelectorManager;
import com.alibaba.nacos.naming.utils.ServiceUtil;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/ns/service"})
public class ServiceController {
    @Autowired
    private SubscribeManager subscribeManager;
    @Autowired
    private ServiceOperatorV2Impl serviceOperatorV2;
    @Autowired
    private SelectorManager selectorManager;

    @PostMapping
    @Secured(action=ActionTypes.WRITE)
    public String create(@RequestParam(defaultValue="public") String namespaceId, @RequestParam String serviceName, @RequestParam(required=false, defaultValue="0.0F") float protectThreshold, @RequestParam(defaultValue="") String metadata, @RequestParam(defaultValue="") String selector) throws Exception {
        ServiceMetadata serviceMetadata = new ServiceMetadata();
        serviceMetadata.setProtectThreshold(protectThreshold);
        serviceMetadata.setSelector(this.parseSelector(selector));
        serviceMetadata.setExtendData(UtilsAndCommons.parseMetadata(metadata));
        serviceMetadata.setEphemeral(false);
        this.getServiceOperator().create(namespaceId, serviceName, serviceMetadata);
        NotifyCenter.publishEvent((Event)new RegisterServiceTraceEvent(System.currentTimeMillis(), namespaceId, NamingUtils.getGroupName((String)serviceName), NamingUtils.getServiceName((String)serviceName)));
        return "ok";
    }

    @DeleteMapping
    @Secured(action=ActionTypes.WRITE)
    public String remove(@RequestParam(defaultValue="public") String namespaceId, @RequestParam String serviceName) throws Exception {
        this.getServiceOperator().delete(namespaceId, serviceName);
        NotifyCenter.publishEvent((Event)new DeregisterServiceTraceEvent(System.currentTimeMillis(), namespaceId, "", serviceName));
        return "ok";
    }

    @GetMapping
    @Secured(action=ActionTypes.READ)
    public ObjectNode detail(@RequestParam(defaultValue="public") String namespaceId, @RequestParam String serviceName) throws NacosException {
        return this.getServiceOperator().queryService(namespaceId, serviceName);
    }

    @GetMapping(value={"/list"})
    @Secured(action=ActionTypes.READ)
    public ObjectNode list(HttpServletRequest request) throws Exception {
        int pageNo = NumberUtils.toInt((String)WebUtils.required((HttpServletRequest)request, (String)"pageNo"));
        int pageSize = NumberUtils.toInt((String)WebUtils.required((HttpServletRequest)request, (String)"pageSize"));
        String namespaceId = WebUtils.optional((HttpServletRequest)request, (String)"namespaceId", (String)"public");
        String groupName = WebUtils.optional((HttpServletRequest)request, (String)"groupName", (String)"DEFAULT_GROUP");
        String selectorString = WebUtils.optional((HttpServletRequest)request, (String)"selector", (String)"");
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        Collection<String> serviceNameList = this.getServiceOperator().listService(namespaceId, groupName, selectorString);
        result.put("count", serviceNameList.size());
        result.replace("doms", JacksonUtils.transferToJsonNode(ServiceUtil.pageServiceName(pageNo, pageSize, serviceNameList)));
        return result;
    }

    @PutMapping
    @Secured(action=ActionTypes.WRITE)
    public String update(HttpServletRequest request) throws Exception {
        String namespaceId = WebUtils.optional((HttpServletRequest)request, (String)"namespaceId", (String)"public");
        String serviceName = WebUtils.required((HttpServletRequest)request, (String)"serviceName");
        ServiceMetadata serviceMetadata = new ServiceMetadata();
        serviceMetadata.setProtectThreshold(NumberUtils.toFloat((String)WebUtils.required((HttpServletRequest)request, (String)"protectThreshold")));
        serviceMetadata.setExtendData(UtilsAndCommons.parseMetadata(WebUtils.optional((HttpServletRequest)request, (String)"metadata", (String)"")));
        serviceMetadata.setSelector(this.parseSelector(WebUtils.optional((HttpServletRequest)request, (String)"selector", (String)"")));
        Service service = Service.newService(namespaceId, NamingUtils.getGroupName((String)serviceName), NamingUtils.getServiceName((String)serviceName));
        this.getServiceOperator().update(service, serviceMetadata);
        return "ok";
    }

    @RequestMapping(value={"/names"})
    @Secured(action=ActionTypes.READ)
    public ObjectNode searchService(@RequestParam(defaultValue="") String namespaceId, @RequestParam(defaultValue="") String expr) throws NacosException {
        HashMap<String, Object> serviceNameMap = new HashMap<String, Object>(16);
        int totalCount = 0;
        if (StringUtils.isNotBlank((String)namespaceId)) {
            Collection<String> names = this.getServiceOperator().searchServiceName(namespaceId, expr);
            serviceNameMap.put(namespaceId, names);
            totalCount = names.size();
        } else {
            for (String each : this.getServiceOperator().listAllNamespace()) {
                Collection<String> names = this.getServiceOperator().searchServiceName(each, expr);
                serviceNameMap.put(each, names);
                totalCount += names.size();
            }
        }
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        result.replace("services", JacksonUtils.transferToJsonNode(serviceNameMap));
        result.put("count", totalCount);
        return result;
    }

    @GetMapping(value={"/subscribers"})
    @Secured(action=ActionTypes.READ)
    public ObjectNode subscribers(HttpServletRequest request) {
        int pageNo = NumberUtils.toInt((String)WebUtils.optional((HttpServletRequest)request, (String)"pageNo", (String)"1"));
        int pageSize = NumberUtils.toInt((String)WebUtils.optional((HttpServletRequest)request, (String)"pageSize", (String)"1000"));
        String namespaceId = WebUtils.optional((HttpServletRequest)request, (String)"namespaceId", (String)"public");
        String serviceName = WebUtils.required((HttpServletRequest)request, (String)"serviceName");
        boolean aggregation = Boolean.parseBoolean(WebUtils.optional((HttpServletRequest)request, (String)"aggregation", (String)String.valueOf(Boolean.TRUE)));
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        int count = 0;
        try {
            int end;
            List<Subscriber> subscribers = this.subscribeManager.getSubscribers(serviceName, namespaceId, aggregation);
            int start = (pageNo - 1) * pageSize;
            if (start < 0) {
                start = 0;
            }
            if ((end = start + pageSize) > (count = subscribers.size())) {
                end = count;
            }
            result.replace("subscribers", JacksonUtils.transferToJsonNode(subscribers.subList(start, end)));
            result.put("count", count);
            return result;
        }
        catch (Exception e) {
            Loggers.SRV_LOG.warn("query subscribers failed!", (Throwable)e);
            result.replace("subscribers", (JsonNode)JacksonUtils.createEmptyArrayNode());
            result.put("count", count);
            return result;
        }
    }

    @GetMapping(value={"/selector/types"})
    public RestResult<List<String>> listSelectorTypes() {
        return RestResultUtils.success(this.selectorManager.getAllSelectorTypes());
    }

    private Selector parseSelector(String selectorJsonString) throws Exception {
        String expression;
        if (StringUtils.isBlank((CharSequence)selectorJsonString)) {
            return new NoneSelector();
        }
        JsonNode selectorJson = JacksonUtils.toObj((String)URLDecoder.decode(selectorJsonString, "UTF-8"));
        String type = Optional.ofNullable(selectorJson.get("type")).orElseThrow(() -> new NacosException(400, "not match any type of selector!")).asText();
        Selector selector = this.selectorManager.parseSelector(type, expression = (String)Optional.ofNullable(selectorJson.get("expression")).map(JsonNode::asText).orElse(null));
        if (Objects.isNull(selector)) {
            throw new NacosException(400, "not match any type of selector!");
        }
        return selector;
    }

    private ServiceOperator getServiceOperator() {
        return this.serviceOperatorV2;
    }
}

