/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.selector.interpreter;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ExpressionInterpreter {
    private static final Set<String> SUPPORTED_INNER_CONNCETORS = new HashSet<String>();
    private static final Set<String> SUPPORTED_OUTER_CONNCETORS = new HashSet<String>();
    private static final String CONSUMER_PREFIX = "CONSUMER.label.";
    private static final String PROVIDER_PREFIX = "PROVIDER.label.";
    private static final char CEQUAL = '=';
    private static final char CAND = '&';

    public static Set<String> parseExpression(String expression) throws NacosException {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return new HashSet<String>();
        }
        expression = StringUtils.deleteWhitespace((String)expression);
        List<String> elements = ExpressionInterpreter.getTerms(expression);
        HashSet<String> gotLabels = new HashSet<String>();
        int index = 0;
        if ((index = ExpressionInterpreter.checkInnerSyntax(elements, index)) == -1) {
            throw new NacosException(400, "parse expression failed!");
        }
        gotLabels.add(elements.get(index++).split(PROVIDER_PREFIX)[1]);
        while (index < elements.size()) {
            if ((index = ExpressionInterpreter.checkOuterSyntax(elements, index)) >= elements.size()) {
                return gotLabels;
            }
            if (index == -1) {
                throw new NacosException(400, "parse expression failed!");
            }
            gotLabels.add(elements.get(index++).split(PROVIDER_PREFIX)[1]);
        }
        return gotLabels;
    }

    public static List<String> getTerms(String expression) {
        ArrayList<String> terms = new ArrayList<String>();
        HashSet<Character> characters = new HashSet<Character>();
        characters.add(Character.valueOf('='));
        characters.add(Character.valueOf('&'));
        char[] chars = expression.toCharArray();
        int lastIndex = 0;
        for (int index = 0; index < chars.length; ++index) {
            char ch = chars[index];
            if (!characters.contains(Character.valueOf(ch))) continue;
            terms.add(expression.substring(lastIndex, index));
            terms.add(expression.substring(index, index + 1));
            lastIndex = ++index;
        }
        terms.add(expression.substring(lastIndex, chars.length));
        return terms;
    }

    private static int skipEmpty(List<String> elements, int start) {
        while (start < elements.size() && StringUtils.isBlank((CharSequence)elements.get(start))) {
            ++start;
        }
        return start;
    }

    private static int checkOuterSyntax(List<String> elements, int start) {
        int index = start;
        if ((index = ExpressionInterpreter.skipEmpty(elements, index)) >= elements.size()) {
            return index;
        }
        if (!SUPPORTED_OUTER_CONNCETORS.contains(elements.get(index++))) {
            return -1;
        }
        return ExpressionInterpreter.checkInnerSyntax(elements, index);
    }

    private static int checkInnerSyntax(List<String> elements, int start) {
        int index = start;
        if ((index = ExpressionInterpreter.skipEmpty(elements, index)) >= elements.size()) {
            return -1;
        }
        if (!elements.get(index).startsWith(CONSUMER_PREFIX)) {
            return -1;
        }
        String labelConsumer = elements.get(index++).split(CONSUMER_PREFIX)[1];
        if ((index = ExpressionInterpreter.skipEmpty(elements, index)) >= elements.size()) {
            return -1;
        }
        if (!SUPPORTED_INNER_CONNCETORS.contains(elements.get(index++))) {
            return -1;
        }
        if ((index = ExpressionInterpreter.skipEmpty(elements, index)) >= elements.size()) {
            return -1;
        }
        if (!elements.get(index).startsWith(PROVIDER_PREFIX)) {
            return -1;
        }
        String labelProvider = elements.get(index).split(PROVIDER_PREFIX)[1];
        if (!labelConsumer.equals(labelProvider)) {
            return -1;
        }
        return index;
    }

    static {
        SUPPORTED_INNER_CONNCETORS.add(String.valueOf('='));
        SUPPORTED_OUTER_CONNCETORS.add(String.valueOf('&'));
    }
}

