/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.push.v2.task;

import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.task.AbstractExecuteTask;
import com.alibaba.nacos.common.trace.event.naming.PushServiceTraceEvent;
import com.alibaba.nacos.naming.core.v2.client.Client;
import com.alibaba.nacos.naming.core.v2.client.manager.ClientManager;
import com.alibaba.nacos.naming.core.v2.metadata.ServiceMetadata;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.pojo.Subscriber;
import com.alibaba.nacos.naming.push.v2.NoRequiredRetryException;
import com.alibaba.nacos.naming.push.v2.PushConfig;
import com.alibaba.nacos.naming.push.v2.PushDataWrapper;
import com.alibaba.nacos.naming.push.v2.hook.PushResult;
import com.alibaba.nacos.naming.push.v2.hook.PushResultHookHolder;
import com.alibaba.nacos.naming.push.v2.task.NamingPushCallback;
import com.alibaba.nacos.naming.push.v2.task.PushDelayTask;
import com.alibaba.nacos.naming.push.v2.task.PushDelayTaskExecuteEngine;
import java.util.Collection;

public class PushExecuteTask
extends AbstractExecuteTask {
    private final Service service;
    private final PushDelayTaskExecuteEngine delayTaskEngine;
    private final PushDelayTask delayTask;

    public PushExecuteTask(Service service, PushDelayTaskExecuteEngine delayTaskEngine, PushDelayTask delayTask) {
        this.service = service;
        this.delayTaskEngine = delayTaskEngine;
        this.delayTask = delayTask;
    }

    public void run() {
        try {
            PushDataWrapper wrapper = this.generatePushData();
            ClientManager clientManager = this.delayTaskEngine.getClientManager();
            for (String each : this.getTargetClientIds()) {
                Client client = clientManager.getClient(each);
                if (null == client) continue;
                Subscriber subscriber = clientManager.getClient(each).getSubscriber(this.service);
                this.delayTaskEngine.getPushExecutor().doPushWithCallback(each, subscriber, wrapper, new ServicePushCallback(each, subscriber, wrapper.getOriginalData(), this.delayTask.isPushToAll()));
            }
        }
        catch (Exception e) {
            Loggers.PUSH.error("Push task for service" + this.service.getGroupedServiceName() + " execute failed ", (Throwable)e);
            this.delayTaskEngine.addTask(this.service, new PushDelayTask(this.service, 1000L));
        }
    }

    private PushDataWrapper generatePushData() {
        ServiceInfo serviceInfo = this.delayTaskEngine.getServiceStorage().getPushData(this.service);
        ServiceMetadata serviceMetadata = this.delayTaskEngine.getMetadataManager().getServiceMetadata(this.service).orElse(null);
        return new PushDataWrapper(serviceMetadata, serviceInfo);
    }

    private Collection<String> getTargetClientIds() {
        return this.delayTask.isPushToAll() ? this.delayTaskEngine.getIndexesManager().getAllClientsSubscribeService(this.service) : this.delayTask.getTargetClients();
    }

    private class ServicePushCallback
    implements NamingPushCallback {
        private final String clientId;
        private final Subscriber subscriber;
        private final ServiceInfo serviceInfo;
        private final long executeStartTime;
        private final boolean isPushToAll;
        private ServiceInfo actualServiceInfo;

        private ServicePushCallback(String clientId, Subscriber subscriber, ServiceInfo serviceInfo, boolean isPushToAll) {
            this.clientId = clientId;
            this.subscriber = subscriber;
            this.serviceInfo = serviceInfo;
            this.isPushToAll = isPushToAll;
            this.executeStartTime = System.currentTimeMillis();
            this.actualServiceInfo = serviceInfo;
        }

        public long getTimeout() {
            return PushConfig.getInstance().getPushTaskTimeout();
        }

        public void onSuccess() {
            long pushFinishTime = System.currentTimeMillis();
            long pushCostTimeForNetWork = pushFinishTime - this.executeStartTime;
            long pushCostTimeForAll = pushFinishTime - PushExecuteTask.this.delayTask.getLastProcessTime();
            long serviceLevelAgreementTime = pushFinishTime - PushExecuteTask.this.service.getLastUpdatedTime();
            if (this.isPushToAll) {
                Loggers.PUSH.info("[PUSH-SUCC] {}ms, all delay time {}ms, SLA {}ms, {}, originalSize={}, DataSize={}, target={}", new Object[]{pushCostTimeForNetWork, pushCostTimeForAll, serviceLevelAgreementTime, PushExecuteTask.this.service, this.serviceInfo.getHosts().size(), this.actualServiceInfo.getHosts().size(), this.subscriber.getIp()});
            } else {
                Loggers.PUSH.info("[PUSH-SUCC] {}ms, all delay time {}ms for subscriber {}, {}, originalSize={}, DataSize={}", new Object[]{pushCostTimeForNetWork, pushCostTimeForAll, this.subscriber.getIp(), PushExecuteTask.this.service, this.serviceInfo.getHosts().size(), this.actualServiceInfo.getHosts().size()});
            }
            PushResult result = PushResult.pushSuccess(PushExecuteTask.this.service, this.clientId, this.actualServiceInfo, this.subscriber, pushCostTimeForNetWork, pushCostTimeForAll, serviceLevelAgreementTime, this.isPushToAll);
            NotifyCenter.publishEvent((Event)this.getPushServiceTraceEvent(pushFinishTime, result));
            PushResultHookHolder.getInstance().pushSuccess(result);
        }

        public void onFail(Throwable e) {
            long pushCostTime = System.currentTimeMillis() - this.executeStartTime;
            Loggers.PUSH.error("[PUSH-FAIL] {}ms, {}, reason={}, target={}", new Object[]{pushCostTime, PushExecuteTask.this.service, e.getMessage(), this.subscriber.getIp()});
            if (!(e instanceof NoRequiredRetryException)) {
                Loggers.PUSH.error("Reason detail: ", e);
                PushExecuteTask.this.delayTaskEngine.addTask(PushExecuteTask.this.service, new PushDelayTask(PushExecuteTask.this.service, PushConfig.getInstance().getPushTaskRetryDelay(), this.clientId));
            }
            PushResult result = PushResult.pushFailed(PushExecuteTask.this.service, this.clientId, this.actualServiceInfo, this.subscriber, pushCostTime, e, this.isPushToAll);
            PushResultHookHolder.getInstance().pushFailed(result);
        }

        @Override
        public void setActualServiceInfo(ServiceInfo actualServiceInfo) {
            this.actualServiceInfo = actualServiceInfo;
        }

        private PushServiceTraceEvent getPushServiceTraceEvent(long eventTime, PushResult result) {
            return new PushServiceTraceEvent(eventTime, result.getNetworkCost(), result.getAllCost(), result.getSla(), result.getSubscriber().getIp(), result.getService().getNamespace(), result.getService().getGroup(), result.getService().getName(), result.getData().getHosts().size());
        }
    }
}

