/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.push.v1;

import com.alibaba.nacos.naming.misc.SwitchDomain;
import com.alibaba.nacos.naming.push.v1.DataSource;
import com.alibaba.nacos.sys.utils.ApplicationUtils;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Objects;

public class PushClient {
    private String namespaceId;
    private String serviceName;
    private String clusters;
    private String agent;
    private String tenant;
    private String app;
    private InetSocketAddress socketAddr;
    private DataSource dataSource;
    private Map<String, String[]> params;
    public long lastRefTime = System.currentTimeMillis();

    public Map<String, String[]> getParams() {
        return this.params;
    }

    public void setParams(Map<String, String[]> params) {
        this.params = params;
    }

    public PushClient(String namespaceId, String serviceName, String clusters, String agent, InetSocketAddress socketAddr, DataSource dataSource, String tenant, String app) {
        this.namespaceId = namespaceId;
        this.serviceName = serviceName;
        this.clusters = clusters;
        this.agent = agent;
        this.socketAddr = socketAddr;
        this.dataSource = dataSource;
        this.tenant = tenant;
        this.app = app;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public boolean zombie() {
        return System.currentTimeMillis() - this.lastRefTime > ((SwitchDomain)ApplicationUtils.getBean(SwitchDomain.class)).getPushCacheMillis(this.serviceName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("serviceName: ").append(this.serviceName).append(", clusters: ").append(this.clusters).append(", address: ").append(this.socketAddr).append(", agent: ").append(this.agent);
        return sb.toString();
    }

    public String getAgent() {
        return this.agent;
    }

    public String getAddrStr() {
        return this.socketAddr.getAddress().getHostAddress() + ":" + this.socketAddr.getPort();
    }

    public String getIp() {
        return this.socketAddr.getAddress().getHostAddress();
    }

    public int getPort() {
        return this.socketAddr.getPort();
    }

    public int hashCode() {
        return Objects.hash(this.serviceName, this.clusters, this.socketAddr);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PushClient)) {
            return false;
        }
        PushClient other = (PushClient)obj;
        return this.serviceName.equals(other.serviceName) && this.clusters.equals(other.clusters) && this.socketAddr.equals(other.socketAddr);
    }

    public String getClusters() {
        return this.clusters;
    }

    public void setClusters(String clusters) {
        this.clusters = clusters;
    }

    public String getNamespaceId() {
        return this.namespaceId;
    }

    public void setNamespaceId(String namespaceId) {
        this.namespaceId = namespaceId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getTenant() {
        return this.tenant;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public String getApp() {
        return this.app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public InetSocketAddress getSocketAddr() {
        return this.socketAddr;
    }

    public void refresh() {
        this.lastRefTime = System.currentTimeMillis();
    }
}

