/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.misc;

import com.alibaba.nacos.core.config.AbstractDynamicConfig;
import com.alibaba.nacos.naming.constants.ClientConstants;
import com.alibaba.nacos.sys.env.EnvUtil;

public class ClientConfig
extends AbstractDynamicConfig {
    private static final String NAMING_CLIENT = "NamingClient";
    private static final ClientConfig INSTANCE = new ClientConfig();
    private long clientExpiredTime = ClientConstants.DEFAULT_CLIENT_EXPIRED_TIME;

    private ClientConfig() {
        super(NAMING_CLIENT);
        this.resetConfig();
    }

    public static ClientConfig getInstance() {
        return INSTANCE;
    }

    public long getClientExpiredTime() {
        return this.clientExpiredTime;
    }

    public void setClientExpiredTime(long clientExpiredTime) {
        this.clientExpiredTime = clientExpiredTime;
    }

    protected void getConfigFromEnv() {
        this.clientExpiredTime = (Long)EnvUtil.getProperty((String)"nacos.naming.client.expired.time", Long.class, (Object)ClientConstants.DEFAULT_CLIENT_EXPIRED_TIME);
    }

    protected String printConfig() {
        return "ClientConfig{clientExpiredTime=" + this.clientExpiredTime + '}';
    }
}

