/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.healthcheck;

import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.trace.event.naming.HealthStateChangeTraceEvent;
import com.alibaba.nacos.naming.core.Cluster;
import com.alibaba.nacos.naming.core.DistroMapper;
import com.alibaba.nacos.naming.core.Instance;
import com.alibaba.nacos.naming.core.Service;
import com.alibaba.nacos.naming.healthcheck.HealthCheckTask;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import com.alibaba.nacos.naming.push.UdpPushService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HealthCheckCommon {
    @Autowired
    private DistroMapper distroMapper;
    @Autowired
    private SwitchDomain switchDomain;
    @Autowired
    private UdpPushService pushService;

    public void reEvaluateCheckRT(long checkRT, HealthCheckTask task, SwitchDomain.HealthParams params) {
        task.setCheckRtLast(checkRT);
        if (checkRT > task.getCheckRtWorst()) {
            task.setCheckRtWorst(checkRT);
        }
        if (checkRT < task.getCheckRtBest()) {
            task.setCheckRtBest(checkRT);
        }
        if ((checkRT = (long)(params.getFactor() * (float)task.getCheckRtNormalized() + (1.0f - params.getFactor()) * (float)checkRT)) > (long)params.getMax()) {
            checkRT = params.getMax();
        }
        if (checkRT < (long)params.getMin()) {
            checkRT = params.getMin();
        }
        task.setCheckRtNormalized(checkRT);
    }

    public void checkOK(Instance ip, HealthCheckTask task, String msg) {
        Cluster cluster = task.getCluster();
        try {
            if (!ip.isHealthy() || !ip.isMockValid()) {
                if (ip.getOkCount().incrementAndGet() >= this.switchDomain.getCheckTimes()) {
                    if (this.distroMapper.responsible(cluster, ip)) {
                        ip.setHealthy(true);
                        ip.setMockValid(true);
                        Service service = cluster.getService();
                        service.setLastModifiedMillis(System.currentTimeMillis());
                        this.pushService.serviceChanged(service);
                        Loggers.EVT_LOG.info("serviceName: {} {POS} {IP-ENABLED} valid: {}:{}@{}, region: {}, msg: {}", new Object[]{cluster.getService().getName(), ip.getIp(), ip.getPort(), cluster.getName(), "unknown", msg});
                        NotifyCenter.publishEvent((Event)new HealthStateChangeTraceEvent(System.currentTimeMillis(), service.getNamespaceId(), service.getGroupName(), service.getName(), ip.getIp(), ip.getPort(), true, msg));
                    } else if (!ip.isMockValid()) {
                        ip.setMockValid(true);
                        Loggers.EVT_LOG.info("serviceName: {} {PROBE} {IP-ENABLED} valid: {}:{}@{}, region: {}, msg: {}", new Object[]{cluster.getService().getName(), ip.getIp(), ip.getPort(), cluster.getName(), "unknown", msg});
                    }
                } else {
                    Loggers.EVT_LOG.info("serviceName: {} {OTHER} {IP-ENABLED} pre-valid: {}:{}@{} in {}, msg: {}", new Object[]{cluster.getService().getName(), ip.getIp(), ip.getPort(), cluster.getName(), ip.getOkCount(), msg});
                }
            }
        }
        catch (Throwable t) {
            Loggers.SRV_LOG.error("[CHECK-OK] error when close check task.", t);
        }
        ip.getFailCount().set(0);
        ip.setBeingChecked(false);
    }

    public void checkFail(Instance ip, HealthCheckTask task, String msg) {
        Cluster cluster = task.getCluster();
        try {
            if (ip.isHealthy() || ip.isMockValid()) {
                if (ip.getFailCount().incrementAndGet() >= this.switchDomain.getCheckTimes()) {
                    if (this.distroMapper.responsible(cluster, ip)) {
                        ip.setHealthy(false);
                        ip.setMockValid(false);
                        Service service = cluster.getService();
                        service.setLastModifiedMillis(System.currentTimeMillis());
                        this.pushService.serviceChanged(service);
                        Loggers.EVT_LOG.info("serviceName: {} {POS} {IP-DISABLED} invalid: {}:{}@{}, region: {}, msg: {}", new Object[]{cluster.getService().getName(), ip.getIp(), ip.getPort(), cluster.getName(), "unknown", msg});
                        NotifyCenter.publishEvent((Event)new HealthStateChangeTraceEvent(System.currentTimeMillis(), service.getNamespaceId(), service.getGroupName(), service.getName(), ip.getIp(), ip.getPort(), false, msg));
                    } else {
                        Loggers.EVT_LOG.info("serviceName: {} {PROBE} {IP-DISABLED} invalid: {}:{}@{}, region: {}, msg: {}", new Object[]{cluster.getService().getName(), ip.getIp(), ip.getPort(), cluster.getName(), "unknown", msg});
                    }
                } else {
                    Loggers.EVT_LOG.info("serviceName: {} {OTHER} {IP-DISABLED} pre-invalid: {}:{}@{} in {}, msg: {}", new Object[]{cluster.getService().getName(), ip.getIp(), ip.getPort(), cluster.getName(), ip.getFailCount(), msg});
                }
            }
        }
        catch (Throwable t) {
            Loggers.SRV_LOG.error("[CHECK-FAIL] error when close check task.", t);
        }
        ip.getOkCount().set(0);
        ip.setBeingChecked(false);
    }

    public void checkFailNow(Instance ip, HealthCheckTask task, String msg) {
        Cluster cluster = task.getCluster();
        try {
            if (ip.isHealthy() || ip.isMockValid()) {
                if (this.distroMapper.responsible(cluster, ip)) {
                    ip.setHealthy(false);
                    ip.setMockValid(false);
                    Service service = cluster.getService();
                    service.setLastModifiedMillis(System.currentTimeMillis());
                    this.pushService.serviceChanged(service);
                    Loggers.EVT_LOG.info("serviceName: {} {POS} {IP-DISABLED} invalid-now: {}:{}@{}, region: {}, msg: {}", new Object[]{cluster.getService().getName(), ip.getIp(), ip.getPort(), cluster.getName(), "unknown", msg});
                    NotifyCenter.publishEvent((Event)new HealthStateChangeTraceEvent(System.currentTimeMillis(), service.getNamespaceId(), service.getGroupName(), service.getName(), ip.getIp(), ip.getPort(), false, msg));
                } else if (ip.isMockValid()) {
                    ip.setMockValid(false);
                    Loggers.EVT_LOG.info("serviceName: {} {PROBE} {IP-DISABLED} invalid-now: {}:{}@{}, region: {}, msg: {}", new Object[]{cluster.getService().getName(), ip.getIp(), ip.getPort(), cluster.getName(), "unknown", msg});
                    Service service = cluster.getService();
                }
            }
        }
        catch (Throwable t) {
            Loggers.SRV_LOG.error("[CHECK-FAIL-NOW] error when close check task.", t);
        }
        ip.getOkCount().set(0);
        ip.setBeingChecked(false);
    }
}

