/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.delay;

import com.alibaba.nacos.common.task.AbstractDelayTask;
import com.alibaba.nacos.common.task.NacosTask;
import com.alibaba.nacos.common.task.NacosTaskProcessor;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.delay.DoubleWriteAction;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.delay.DoubleWriteContent;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.execute.DoubleWriteInstanceChangeToV1Task;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.execute.DoubleWriteMetadataChangeToV1Task;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.execute.DoubleWriteServiceRemovalToV1Task;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.NamingExecuteTaskDispatcher;

public class ServiceChangeV2Task
extends AbstractDelayTask {
    private final Service changedService;
    private DoubleWriteContent content;
    private DoubleWriteAction action;

    public ServiceChangeV2Task(Service service, DoubleWriteContent content) {
        this(service, content, DoubleWriteAction.UPDATE);
    }

    public ServiceChangeV2Task(Service service, DoubleWriteContent content, DoubleWriteAction action) {
        this.changedService = service;
        this.content = action == DoubleWriteAction.REMOVE ? DoubleWriteContent.BOTH : content;
        this.action = action;
        this.setTaskInterval(1000L);
        this.setLastProcessTime(System.currentTimeMillis());
    }

    public Service getChangedService() {
        return this.changedService;
    }

    public DoubleWriteContent getContent() {
        return this.content;
    }

    public DoubleWriteAction getAction() {
        return this.action;
    }

    public void merge(AbstractDelayTask task) {
        if (!(task instanceof ServiceChangeV2Task)) {
            return;
        }
        ServiceChangeV2Task oldTask = (ServiceChangeV2Task)task;
        if (!this.action.equals((Object)oldTask.getAction())) {
            this.action = DoubleWriteAction.REMOVE;
            this.content = DoubleWriteContent.BOTH;
            return;
        }
        if (!this.content.equals((Object)oldTask.getContent())) {
            this.content = DoubleWriteContent.BOTH;
        }
    }

    public static String getKey(Service service) {
        return "v2:" + service.getNamespace() + "_" + service.getGroupedServiceName() + "_" + service.isEphemeral();
    }

    public static class ServiceChangeV2TaskProcessor
    implements NacosTaskProcessor {
        public boolean process(NacosTask task) {
            ServiceChangeV2Task serviceTask = (ServiceChangeV2Task)task;
            Service changedService = serviceTask.getChangedService();
            if (serviceTask.getAction() == DoubleWriteAction.REMOVE) {
                Loggers.SRV_LOG.info("double write removal of service {}", (Object)changedService);
                this.dispatchRemoveServiceTask(changedService);
                return true;
            }
            Loggers.SRV_LOG.info("double write for service {}, content {}", (Object)changedService, (Object)serviceTask.getContent());
            switch (serviceTask.getContent()) {
                case INSTANCE: {
                    this.dispatchInstanceChangeTask(changedService);
                    break;
                }
                case METADATA: {
                    this.dispatchMetadataChangeTask(changedService);
                    break;
                }
                default: {
                    this.dispatchAllTask(changedService);
                }
            }
            return true;
        }

        private void dispatchRemoveServiceTask(Service changedService) {
            DoubleWriteServiceRemovalToV1Task serviceRemovalTask = new DoubleWriteServiceRemovalToV1Task(changedService);
            NamingExecuteTaskDispatcher.getInstance().dispatchAndExecuteTask(changedService.getGroupedServiceName(), serviceRemovalTask);
        }

        private void dispatchInstanceChangeTask(Service changedService) {
            DoubleWriteInstanceChangeToV1Task instanceTask = new DoubleWriteInstanceChangeToV1Task(changedService);
            NamingExecuteTaskDispatcher.getInstance().dispatchAndExecuteTask(changedService.getGroupedServiceName(), instanceTask);
        }

        private void dispatchMetadataChangeTask(Service changedService) {
            DoubleWriteMetadataChangeToV1Task metadataTask = new DoubleWriteMetadataChangeToV1Task(changedService);
            NamingExecuteTaskDispatcher.getInstance().dispatchAndExecuteTask(changedService.getGroupedServiceName(), metadataTask);
        }

        private void dispatchAllTask(Service changedService) {
            this.dispatchMetadataChangeTask(changedService);
            this.dispatchInstanceChangeTask(changedService);
        }
    }
}

