/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.naming.core.Cluster;
import com.alibaba.nacos.naming.core.ClusterOperator;
import com.alibaba.nacos.naming.core.Service;
import com.alibaba.nacos.naming.core.ServiceManager;
import com.alibaba.nacos.naming.core.v2.metadata.ClusterMetadata;
import com.alibaba.nacos.naming.misc.Loggers;

@org.springframework.stereotype.Service
public class ClusterOperatorV1Impl
implements ClusterOperator {
    private final ServiceManager serviceManager;

    public ClusterOperatorV1Impl(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    @Override
    public void updateClusterMetadata(String namespaceId, String serviceName, String clusterName, ClusterMetadata clusterMetadata) throws NacosException {
        Service service = this.serviceManager.getService(namespaceId, serviceName);
        this.serviceManager.checkServiceIsNull(service, namespaceId, serviceName);
        Cluster cluster = service.getClusterMap().get(clusterName);
        if (cluster == null) {
            Loggers.SRV_LOG.warn("[UPDATE-CLUSTER] cluster not exist, will create it: {}, service: {}", (Object)clusterName, (Object)serviceName);
            cluster = new Cluster(clusterName, service);
        }
        cluster.setDefCkport(clusterMetadata.getHealthyCheckPort());
        cluster.setUseIPPort4Check(clusterMetadata.isUseInstancePortForCheck());
        cluster.setHealthChecker(clusterMetadata.getHealthChecker());
        cluster.setMetadata(clusterMetadata.getExtendData());
        cluster.init();
        service.getClusterMap().put(clusterName, cluster);
        service.setLastModifiedMillis(System.currentTimeMillis());
        service.recalculateChecksum();
        service.validate();
        this.serviceManager.addOrReplaceService(service);
    }
}

