/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.consistency.persistent.raft;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import com.alibaba.nacos.naming.cluster.ServerStatus;
import com.alibaba.nacos.naming.consistency.Datum;
import com.alibaba.nacos.naming.consistency.KeyBuilder;
import com.alibaba.nacos.naming.consistency.RecordListener;
import com.alibaba.nacos.naming.consistency.persistent.ClusterVersionJudgement;
import com.alibaba.nacos.naming.consistency.persistent.PersistentConsistencyService;
import com.alibaba.nacos.naming.consistency.persistent.raft.RaftCore;
import com.alibaba.nacos.naming.consistency.persistent.raft.RaftPeer;
import com.alibaba.nacos.naming.consistency.persistent.raft.RaftPeerSet;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import com.alibaba.nacos.naming.pojo.Record;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

@Deprecated
@DependsOn(value={"ProtocolManager"})
@Service
public class RaftConsistencyServiceImpl
implements PersistentConsistencyService {
    private final RaftCore raftCore;
    private final RaftPeerSet peers;
    private final SwitchDomain switchDomain;
    private volatile boolean stopWork = false;
    private String errorMsg;

    public RaftConsistencyServiceImpl(ClusterVersionJudgement versionJudgement, RaftCore raftCore, SwitchDomain switchDomain) {
        this.raftCore = raftCore;
        this.peers = raftCore.getPeerSet();
        this.switchDomain = switchDomain;
        versionJudgement.registerObserver(isAllNewVersion -> {
            this.stopWork = isAllNewVersion;
            if (this.stopWork) {
                try {
                    this.raftCore.shutdown();
                }
                catch (NacosException e) {
                    throw new NacosRuntimeException(500, (Throwable)e);
                }
            }
        }, 1000);
    }

    @PostConstruct
    protected void init() throws Exception {
        if (((Boolean)EnvUtil.getProperty((String)"nacos.naming.use-new-raft.first", Boolean.class, (Object)false)).booleanValue()) {
            this.raftCore.shutdown();
        }
    }

    @Override
    public void put(String key, Record value) throws NacosException {
        this.checkIsStopWork();
        try {
            this.raftCore.signalPublish(key, value);
        }
        catch (Exception e) {
            Loggers.RAFT.error("Raft put failed.", (Throwable)e);
            throw new NacosException(500, "Raft put failed, key:" + key + ", value:" + value, (Throwable)e);
        }
    }

    @Override
    public void remove(String key) throws NacosException {
        this.checkIsStopWork();
        try {
            if (KeyBuilder.matchInstanceListKey(key) && !this.raftCore.isLeader()) {
                this.raftCore.onDelete(key, this.peers.getLeader());
            } else {
                this.raftCore.signalDelete(key);
            }
            this.raftCore.unListenAll(key);
        }
        catch (Exception e) {
            Loggers.RAFT.error("Raft remove failed.", (Throwable)e);
            throw new NacosException(500, "Raft remove failed, key:" + key, (Throwable)e);
        }
    }

    @Override
    public Datum get(String key) throws NacosException {
        this.checkIsStopWork();
        return this.raftCore.getDatum(key);
    }

    @Override
    public void listen(String key, RecordListener listener) throws NacosException {
        this.raftCore.listen(key, listener);
    }

    @Override
    public void unListen(String key, RecordListener listener) throws NacosException {
        this.raftCore.unListen(key, listener);
    }

    @Override
    public boolean isAvailable() {
        return this.raftCore.isInitialized() || ServerStatus.UP.name().equals(this.switchDomain.getOverriddenServerStatus());
    }

    @Override
    public Optional<String> getErrorMsg() {
        String errorMsg = !this.raftCore.isInitialized() && !ServerStatus.UP.name().equals(this.switchDomain.getOverriddenServerStatus()) ? "The old raft protocol node is not initialized" : null;
        return Optional.ofNullable(errorMsg);
    }

    public void onPut(Datum datum, RaftPeer source) throws NacosException {
        try {
            this.raftCore.onPublish(datum, source);
        }
        catch (Exception e) {
            Loggers.RAFT.error("Raft onPut failed.", (Throwable)e);
            throw new NacosException(500, "Raft onPut failed, datum:" + datum + ", source: " + source, (Throwable)e);
        }
    }

    public void onRemove(Datum datum, RaftPeer source) throws NacosException {
        try {
            this.raftCore.onDelete(datum.key, source);
        }
        catch (Exception e) {
            Loggers.RAFT.error("Raft onRemove failed.", (Throwable)e);
            throw new NacosException(500, "Raft onRemove failed, datum:" + datum + ", source: " + source, (Throwable)e);
        }
    }

    private void checkIsStopWork() {
        if (this.stopWork) {
            throw new IllegalStateException("old raft protocol already stop work");
        }
    }
}

