/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.consistency.persistent.impl;

import com.alibaba.nacos.consistency.snapshot.Reader;
import com.alibaba.nacos.consistency.snapshot.SnapshotOperation;
import com.alibaba.nacos.consistency.snapshot.Writer;
import com.alibaba.nacos.core.distributed.raft.utils.RaftExecutor;
import com.alibaba.nacos.core.utils.TimerContext;
import com.alibaba.nacos.naming.misc.Loggers;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import org.slf4j.Logger;

public abstract class AbstractSnapshotOperation
implements SnapshotOperation {
    protected static final String CHECK_SUM_KEY = "checksum";
    private final ReentrantReadWriteLock.WriteLock writeLock;

    public AbstractSnapshotOperation(ReentrantReadWriteLock lock) {
        this.writeLock = lock.writeLock();
    }

    public void onSnapshotSave(Writer writer, BiConsumer<Boolean, Throwable> callFinally) {
        RaftExecutor.doSnapshot(() -> {
            TimerContext.start((String)this.getSnapshotSaveTag());
            ReentrantReadWriteLock.WriteLock lock = this.writeLock;
            lock.lock();
            try {
                callFinally.accept(this.writeSnapshot(writer), null);
            }
            catch (Throwable t) {
                Loggers.RAFT.error("Fail to compress snapshot, path={}, file list={}.", new Object[]{writer.getPath(), writer.listFiles(), t});
                callFinally.accept(false, t);
            }
            finally {
                lock.unlock();
                TimerContext.end((String)this.getSnapshotSaveTag(), (Logger)Loggers.RAFT);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onSnapshotLoad(Reader reader) {
        TimerContext.start((String)this.getSnapshotLoadTag());
        ReentrantReadWriteLock.WriteLock lock = this.writeLock;
        lock.lock();
        try {
            boolean bl = this.readSnapshot(reader);
            return bl;
        }
        catch (Throwable t) {
            Loggers.RAFT.error("Fail to load snapshot, path={}, file list={}.", new Object[]{reader.getPath(), reader.listFiles(), t});
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
            TimerContext.end((String)this.getSnapshotLoadTag(), (Logger)Loggers.RAFT);
        }
    }

    protected abstract boolean writeSnapshot(Writer var1) throws Exception;

    protected abstract boolean readSnapshot(Reader var1) throws Exception;

    protected abstract String getSnapshotSaveTag();

    protected abstract String getSnapshotLoadTag();
}

