/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.consistency.ephemeral.distro.combined;

import com.alibaba.nacos.common.task.AbstractDelayTask;
import com.alibaba.nacos.consistency.DataOperation;
import com.alibaba.nacos.core.distributed.distro.entity.DistroKey;
import com.alibaba.nacos.core.distributed.distro.task.delay.DistroDelayTask;
import com.alibaba.nacos.naming.consistency.ephemeral.distro.combined.DistroHttpCombinedKey;
import java.util.HashSet;
import java.util.Set;

public class DistroHttpCombinedKeyDelayTask
extends DistroDelayTask {
    private final int batchSize;
    private final Set<String> actualResourceKeys = new HashSet<String>();

    public DistroHttpCombinedKeyDelayTask(DistroKey distroKey, DataOperation action, long delayTime, int batchSize) {
        super(distroKey, action, delayTime);
        this.batchSize = batchSize;
    }

    public Set<String> getActualResourceKeys() {
        return this.actualResourceKeys;
    }

    public void merge(AbstractDelayTask task) {
        this.actualResourceKeys.addAll(((DistroHttpCombinedKeyDelayTask)task).getActualResourceKeys());
        if (this.actualResourceKeys.size() >= this.batchSize) {
            DistroHttpCombinedKey.incrementSequence();
            this.setLastProcessTime(0L);
        } else {
            this.setLastProcessTime(task.getLastProcessTime());
        }
    }

    public DistroKey getDistroKey() {
        DistroKey taskKey = super.getDistroKey();
        DistroHttpCombinedKey result = new DistroHttpCombinedKey("com.alibaba.nacos.naming.iplist.", taskKey.getTargetServer());
        result.setResourceKey(taskKey.getResourceKey());
        result.getActualResourceTypes().addAll(this.actualResourceKeys);
        return result;
    }
}

