/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.consistency;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.naming.consistency.ConsistencyService;
import com.alibaba.nacos.naming.consistency.Datum;
import com.alibaba.nacos.naming.consistency.KeyBuilder;
import com.alibaba.nacos.naming.consistency.RecordListener;
import com.alibaba.nacos.naming.consistency.ephemeral.EphemeralConsistencyService;
import com.alibaba.nacos.naming.consistency.persistent.PersistentConsistencyServiceDelegateImpl;
import com.alibaba.nacos.naming.pojo.Record;
import java.util.Optional;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

@DependsOn(value={"ProtocolManager"})
@Service(value="consistencyDelegate")
public class DelegateConsistencyServiceImpl
implements ConsistencyService {
    private final PersistentConsistencyServiceDelegateImpl persistentConsistencyService;
    private final EphemeralConsistencyService ephemeralConsistencyService;

    public DelegateConsistencyServiceImpl(PersistentConsistencyServiceDelegateImpl persistentConsistencyService, EphemeralConsistencyService ephemeralConsistencyService) {
        this.persistentConsistencyService = persistentConsistencyService;
        this.ephemeralConsistencyService = ephemeralConsistencyService;
    }

    @Override
    public void put(String key, Record value) throws NacosException {
        this.mapConsistencyService(key).put(key, value);
    }

    @Override
    public void remove(String key) throws NacosException {
        this.mapConsistencyService(key).remove(key);
    }

    @Override
    public Datum get(String key) throws NacosException {
        return this.mapConsistencyService(key).get(key);
    }

    @Override
    public void listen(String key, RecordListener listener) throws NacosException {
        if ("com.alibaba.nacos.naming.domains.meta.".equals(key)) {
            this.persistentConsistencyService.listen(key, listener);
            this.ephemeralConsistencyService.listen(key, listener);
            return;
        }
        this.mapConsistencyService(key).listen(key, listener);
    }

    @Override
    public void unListen(String key, RecordListener listener) throws NacosException {
        this.mapConsistencyService(key).unListen(key, listener);
    }

    @Override
    public boolean isAvailable() {
        return this.ephemeralConsistencyService.isAvailable() && this.persistentConsistencyService.isAvailable();
    }

    @Override
    public Optional<String> getErrorMsg() {
        String errorMsg = this.ephemeralConsistencyService.getErrorMsg().isPresent() && this.persistentConsistencyService.getErrorMsg().isPresent() ? "'" + this.ephemeralConsistencyService.getErrorMsg().get() + "' in Distro protocol and '" + this.persistentConsistencyService.getErrorMsg().get() + "' in jRaft protocol" : (this.ephemeralConsistencyService.getErrorMsg().isPresent() && !this.persistentConsistencyService.getErrorMsg().isPresent() ? this.ephemeralConsistencyService.getErrorMsg().get() : (!this.ephemeralConsistencyService.getErrorMsg().isPresent() && this.persistentConsistencyService.getErrorMsg().isPresent() ? this.persistentConsistencyService.getErrorMsg().get() : null));
        return Optional.ofNullable(errorMsg);
    }

    private ConsistencyService mapConsistencyService(String key) {
        return KeyBuilder.matchEphemeralKey(key) ? this.ephemeralConsistencyService : this.persistentConsistencyService;
    }
}

