/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.datasource.impl.mysql;

import com.alibaba.nacos.common.utils.NamespaceUtil;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.plugin.datasource.mapper.AbstractMapper;
import com.alibaba.nacos.plugin.datasource.mapper.ConfigInfoMapper;
import java.sql.Timestamp;
import java.util.Map;

public class ConfigInfoMapperByMySql
extends AbstractMapper
implements ConfigInfoMapper {
    private static final String DATA_ID = "dataId";
    private static final String GROUP = "group";
    private static final String APP_NAME = "appName";
    private static final String CONTENT = "content";
    private static final String TENANT = "tenant";

    @Override
    public String findConfigInfoByAppFetchRows(int startRow, int pageSize) {
        return "SELECT id,data_id,group_id,tenant_id,app_name,content FROM config_info WHERE tenant_id LIKE ? AND app_name= ? LIMIT " + startRow + "," + pageSize;
    }

    @Override
    public String getTenantIdList(int startRow, int pageSize) {
        return "SELECT tenant_id FROM config_info WHERE tenant_id != '" + NamespaceUtil.getNamespaceDefaultId() + "' GROUP BY tenant_id LIMIT " + startRow + "," + pageSize;
    }

    @Override
    public String getGroupIdList(int startRow, int pageSize) {
        return "SELECT group_id FROM config_info WHERE tenant_id ='" + NamespaceUtil.getNamespaceDefaultId() + "' GROUP BY group_id LIMIT " + startRow + "," + pageSize;
    }

    @Override
    public String findAllConfigKey(int startRow, int pageSize) {
        return " SELECT data_id,group_id,app_name  FROM (  SELECT id FROM config_info WHERE tenant_id LIKE ? ORDER BY id LIMIT " + startRow + "," + pageSize + " ) g, config_info t WHERE g.id = t.id  ";
    }

    @Override
    public String findAllConfigInfoBaseFetchRows(int startRow, int pageSize) {
        return "SELECT t.id,data_id,group_id,content,md5 FROM ( SELECT id FROM config_info ORDER BY id LIMIT ?,?  )  g, config_info t  WHERE g.id = t.id ";
    }

    @Override
    public String findAllConfigInfoFragment(int startRow, int pageSize) {
        return "SELECT id,data_id,group_id,tenant_id,app_name,content,md5,gmt_modified,type,encrypted_data_key FROM config_info WHERE id > ? ORDER BY id ASC LIMIT " + startRow + "," + pageSize;
    }

    @Override
    public String findChangeConfigFetchRows(Map<String, String> params, Timestamp startTime, Timestamp endTime, int startRow, int pageSize, long lastMaxId) {
        String tenant = params.get(TENANT);
        String dataId = params.get(DATA_ID);
        String group = params.get(GROUP);
        String appName = params.get(APP_NAME);
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String sqlFetchRows = "SELECT id,data_id,group_id,tenant_id,app_name,content,type,md5,gmt_modified FROM config_info WHERE ";
        String where = " 1=1 ";
        if (!StringUtils.isBlank((CharSequence)dataId)) {
            where = where + " AND data_id LIKE ? ";
        }
        if (!StringUtils.isBlank((CharSequence)group)) {
            where = where + " AND group_id LIKE ? ";
        }
        if (!StringUtils.isBlank((CharSequence)tenantTmp)) {
            where = where + " AND tenant_id = ? ";
        }
        if (!StringUtils.isBlank((CharSequence)appName)) {
            where = where + " AND app_name = ? ";
        }
        if (startTime != null) {
            where = where + " AND gmt_modified >=? ";
        }
        if (endTime != null) {
            where = where + " AND gmt_modified <=? ";
        }
        return "SELECT id,data_id,group_id,tenant_id,app_name,content,type,md5,gmt_modified FROM config_info WHERE " + where + " AND id > " + lastMaxId + " ORDER BY id ASC LIMIT " + 0 + "," + pageSize;
    }

    @Override
    public String listGroupKeyMd5ByPageFetchRows(int startRow, int pageSize) {
        return "SELECT t.id,data_id,group_id,tenant_id,app_name,md5,type,gmt_modified,encrypted_data_key FROM ( SELECT id FROM config_info ORDER BY id LIMIT " + startRow + "," + pageSize + " ) g, config_info t WHERE g.id = t.id";
    }

    @Override
    public String findConfigInfoBaseLikeFetchRows(Map<String, String> params, int startRow, int pageSize) {
        String sqlFetchRows = "SELECT id,data_id,group_id,tenant_id,content FROM config_info WHERE ";
        String where = " 1=1 AND tenant_id='" + NamespaceUtil.getNamespaceDefaultId() + "' ";
        if (!StringUtils.isBlank((CharSequence)params.get(DATA_ID))) {
            where = where + " AND data_id LIKE ? ";
        }
        if (!StringUtils.isBlank((CharSequence)params.get(GROUP))) {
            where = where + " AND group_id LIKE ";
        }
        if (!StringUtils.isBlank((CharSequence)params.get(CONTENT))) {
            where = where + " AND content LIKE ? ";
        }
        return "SELECT id,data_id,group_id,tenant_id,content FROM config_info WHERE " + where + " LIMIT " + startRow + "," + pageSize;
    }

    @Override
    public String findConfigInfo4PageFetchRows(Map<String, String> params, int startRow, int pageSize) {
        String appName = params.get(APP_NAME);
        String dataId = params.get(DATA_ID);
        String group = params.get(GROUP);
        String content = params.get(CONTENT);
        String sql = "SELECT id,data_id,group_id,tenant_id,app_name,content,type,encrypted_data_key FROM config_info";
        StringBuilder where = new StringBuilder(" WHERE ");
        where.append(" tenant_id=? ");
        if (StringUtils.isNotBlank((String)dataId)) {
            where.append(" AND data_id=? ");
        }
        if (StringUtils.isNotBlank((String)group)) {
            where.append(" AND group_id=? ");
        }
        if (StringUtils.isNotBlank((String)appName)) {
            where.append(" AND app_name=? ");
        }
        if (!StringUtils.isBlank((CharSequence)content)) {
            where.append(" AND content LIKE ? ");
        }
        return "SELECT id,data_id,group_id,tenant_id,app_name,content,type,encrypted_data_key FROM config_info" + where + " LIMIT " + startRow + "," + pageSize;
    }

    @Override
    public String findConfigInfoBaseByGroupFetchRows(int startRow, int pageSize) {
        return "SELECT id,data_id,group_id,content FROM config_info WHERE group_id=? AND tenant_id=? LIMIT " + startRow + "," + pageSize;
    }

    @Override
    public String findConfigInfoLike4PageFetchRows(Map<String, String> params, int startRow, int pageSize) {
        String dataId = params.get(DATA_ID);
        String group = params.get(GROUP);
        String appName = params.get(APP_NAME);
        String content = params.get(CONTENT);
        String sqlFetchRows = "SELECT id,data_id,group_id,tenant_id,app_name,content,encrypted_data_key FROM config_info";
        StringBuilder where = new StringBuilder(" WHERE ");
        where.append(" tenant_id LIKE ? ");
        if (!StringUtils.isBlank((CharSequence)dataId)) {
            where.append(" AND data_id LIKE ? ");
        }
        if (!StringUtils.isBlank((CharSequence)group)) {
            where.append(" AND group_id LIKE ? ");
        }
        if (!StringUtils.isBlank((CharSequence)appName)) {
            where.append(" AND app_name = ? ");
        }
        if (!StringUtils.isBlank((CharSequence)content)) {
            where.append(" AND content LIKE ? ");
        }
        return "SELECT id,data_id,group_id,tenant_id,app_name,content,encrypted_data_key FROM config_info" + where + " LIMIT " + startRow + "," + pageSize;
    }

    @Override
    public String findAllConfigInfoFetchRows(int startRow, int pageSize) {
        return "SELECT t.id,data_id,group_id,tenant_id,app_name,content,md5  FROM (  SELECT id FROM config_info WHERE tenant_id LIKE ? ORDER BY id LIMIT ?,? ) g, config_info t  WHERE g.id = t.id ";
    }

    @Override
    public String getDataSource() {
        return "mysql";
    }
}

