/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.remote;

import com.alibaba.nacos.core.monitor.MetricsMonitor;
import com.alibaba.nacos.core.remote.Connection;
import com.alibaba.nacos.core.remote.RuntimeConnectionEjector;
import com.alibaba.nacos.plugin.control.Loggers;
import java.util.Map;

public class NacosRuntimeConnectionEjector
extends RuntimeConnectionEjector {
    @Override
    public void doEject() {
        try {
            Map<String, Connection> connections = this.connectionManager.connections;
            int totalCount = connections.size();
            Loggers.CONNECTION.info("Connection check task start");
            MetricsMonitor.getLongConnectionMonitor().set(totalCount);
            int currentSdkClientCount = this.connectionManager.currentSdkClientCount();
            Loggers.CONNECTION.info("Long connection metrics detail ,Total count ={}, sdkCount={},clusterCount={}", new Object[]{totalCount, currentSdkClientCount, totalCount - currentSdkClientCount});
            Loggers.CONNECTION.info("Connection check task end");
        }
        catch (Throwable e) {
            Loggers.CONNECTION.error("Error occurs during connection check... ", e);
        }
    }

    @Override
    public String getName() {
        return "nacos";
    }
}

