/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.remote;

import com.alibaba.nacos.api.remote.RpcScheduledExecutor;
import com.alibaba.nacos.api.remote.request.ConnectResetRequest;
import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.common.remote.exception.ConnectionAlreadyClosedException;
import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.remote.ClientConnectionEventListenerRegistry;
import com.alibaba.nacos.core.remote.Connection;
import com.alibaba.nacos.core.remote.ConnectionMeta;
import com.alibaba.nacos.core.remote.NacosRuntimeConnectionEjector;
import com.alibaba.nacos.core.remote.RuntimeConnectionEjector;
import com.alibaba.nacos.plugin.control.ControlManagerCenter;
import com.alibaba.nacos.plugin.control.Loggers;
import com.alibaba.nacos.plugin.control.configs.ControlConfigs;
import com.alibaba.nacos.plugin.control.connection.request.ConnectionCheckRequest;
import com.alibaba.nacos.plugin.control.connection.response.ConnectionCheckResponse;
import com.alibaba.nacos.plugin.control.connection.rule.ConnectionControlRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class ConnectionManager {
    private static final Logger LOGGER = Loggers.CONNECTION;
    private Map<String, AtomicInteger> connectionForClientIp = new ConcurrentHashMap<String, AtomicInteger>(16);
    Map<String, Connection> connections = new ConcurrentHashMap<String, Connection>();
    private RuntimeConnectionEjector runtimeConnectionEjector;
    private ClientConnectionEventListenerRegistry clientConnectionEventListenerRegistry;

    public ConnectionManager(ClientConnectionEventListenerRegistry clientConnectionEventListenerRegistry) {
        this.clientConnectionEventListenerRegistry = clientConnectionEventListenerRegistry;
    }

    public boolean traced(String clientIp) {
        ConnectionControlRule connectionControlRule = ControlManagerCenter.getInstance().getConnectionControlManager().getConnectionLimitRule();
        return connectionControlRule != null && connectionControlRule.getMonitorIpList() != null && connectionControlRule.getMonitorIpList().contains(clientIp);
    }

    public boolean checkValid(String connectionId) {
        return this.connections.containsKey(connectionId);
    }

    public synchronized boolean register(String connectionId, Connection connection) {
        if (connection.isConnected()) {
            String clientIp = connection.getMetaInfo().clientIp;
            if (this.connections.containsKey(connectionId)) {
                return true;
            }
            if (this.checkLimit(connection)) {
                return false;
            }
            if (this.traced(clientIp)) {
                connection.setTraced(true);
            }
            this.connections.put(connectionId, connection);
            if (!this.connectionForClientIp.containsKey(clientIp)) {
                this.connectionForClientIp.put(clientIp, new AtomicInteger(0));
            }
            this.connectionForClientIp.get(clientIp).getAndIncrement();
            this.clientConnectionEventListenerRegistry.notifyClientConnected(connection);
            LOGGER.info("new connection registered successfully, connectionId = {},connection={} ", (Object)connectionId, (Object)connection);
            return true;
        }
        return false;
    }

    private boolean checkLimit(Connection connection) {
        if (connection.getMetaInfo().isClusterSource()) {
            return false;
        }
        ConnectionMeta metaInfo = connection.getMetaInfo();
        ConnectionCheckRequest connectionCheckRequest = new ConnectionCheckRequest(metaInfo.getClientIp(), metaInfo.getAppName(), metaInfo.getLabel("source"));
        connectionCheckRequest.setLabels(connection.getLabels());
        ConnectionCheckResponse checkResponse = ControlManagerCenter.getInstance().getConnectionControlManager().check(connectionCheckRequest);
        return !checkResponse.isSuccess();
    }

    public synchronized void unregister(String connectionId) {
        Connection remove = this.connections.remove(connectionId);
        if (remove != null) {
            int count;
            String clientIp = remove.getMetaInfo().clientIp;
            AtomicInteger atomicInteger = this.connectionForClientIp.get(clientIp);
            if (atomicInteger != null && (count = atomicInteger.decrementAndGet()) <= 0) {
                this.connectionForClientIp.remove(clientIp);
            }
            remove.close();
            LOGGER.info("[{}]Connection unregistered successfully. ", (Object)connectionId);
            this.clientConnectionEventListenerRegistry.notifyClientDisConnected(remove);
        }
    }

    public Connection getConnection(String connectionId) {
        return this.connections.get(connectionId);
    }

    public List<Connection> getConnectionByIp(String clientIp) {
        Set<Map.Entry<String, Connection>> entries = this.connections.entrySet();
        ArrayList<Connection> connections = new ArrayList<Connection>();
        for (Map.Entry<String, Connection> entry : entries) {
            Connection value = entry.getValue();
            if (!clientIp.equals(value.getMetaInfo().clientIp)) continue;
            connections.add(value);
        }
        return connections;
    }

    public void initConnectionEjector() {
        String connectionRuntimeEjector = null;
        try {
            connectionRuntimeEjector = ControlConfigs.getInstance().getConnectionRuntimeEjector();
            Collection ejectors = NacosServiceLoader.load(RuntimeConnectionEjector.class);
            for (RuntimeConnectionEjector runtimeConnectionEjectorLoad : ejectors) {
                if (!runtimeConnectionEjectorLoad.getName().equalsIgnoreCase(connectionRuntimeEjector)) continue;
                Loggers.CONNECTION.info("Found connection runtime ejector for name {}", (Object)connectionRuntimeEjector);
                runtimeConnectionEjectorLoad.setConnectionManager(this);
                this.runtimeConnectionEjector = runtimeConnectionEjectorLoad;
            }
        }
        catch (Throwable throwable) {
            Loggers.CONNECTION.warn("Fail to load  runtime ejector ", throwable);
        }
        if (this.runtimeConnectionEjector == null) {
            Loggers.CONNECTION.info("Fail to find connection runtime ejector for name {},use default", (Object)connectionRuntimeEjector);
            NacosRuntimeConnectionEjector nacosRuntimeConnectionEjector = new NacosRuntimeConnectionEjector();
            nacosRuntimeConnectionEjector.setConnectionManager(this);
            this.runtimeConnectionEjector = nacosRuntimeConnectionEjector;
        }
    }

    public int getCurrentConnectionCount() {
        return this.connections.size();
    }

    public void refreshActiveTime(String connectionId) {
        Connection connection = this.connections.get(connectionId);
        if (connection != null) {
            connection.freshActiveTime();
        }
    }

    @PostConstruct
    public void start() {
        this.initConnectionEjector();
        RpcScheduledExecutor.COMMON_SERVER_EXECUTOR.scheduleWithFixedDelay(() -> this.runtimeConnectionEjector.doEject(), 1000L, 3000L, TimeUnit.MILLISECONDS);
    }

    public void loadCount(int loadClient, String redirectAddress) {
        this.runtimeConnectionEjector.setLoadClient(loadClient);
        this.runtimeConnectionEjector.setRedirectAddress(redirectAddress);
    }

    public void loadSingle(String connectionId, String redirectAddress) {
        Connection connection = this.getConnection(connectionId);
        if (connection != null && connection.getMetaInfo().isSdkSource()) {
            ConnectResetRequest connectResetRequest = new ConnectResetRequest();
            if (StringUtils.isNotBlank((String)redirectAddress) && redirectAddress.contains(":")) {
                String[] split = redirectAddress.split(":");
                connectResetRequest.setServerIp(split[0]);
                connectResetRequest.setServerPort(split[1]);
            }
            try {
                connection.request((Request)connectResetRequest, 3000L);
            }
            catch (ConnectionAlreadyClosedException e) {
                this.unregister(connectionId);
            }
            catch (Exception e) {
                LOGGER.error("error occurs when expel connection, connectionId: {} ", (Object)connectionId, (Object)e);
            }
        }
    }

    public int currentClientsCount() {
        return this.connections.size();
    }

    public int currentClientsCount(Map<String, String> filterLabels) {
        int count = 0;
        for (Connection connection : this.connections.values()) {
            Map<String, String> labels = connection.getMetaInfo().labels;
            boolean disMatchFound = false;
            for (Map.Entry<String, String> entry : filterLabels.entrySet()) {
                if (entry.getValue().equals(labels.get(entry.getKey()))) continue;
                disMatchFound = true;
                break;
            }
            if (disMatchFound) continue;
            ++count;
        }
        return count;
    }

    public int currentSdkClientCount() {
        HashMap<String, String> filter = new HashMap<String, String>(2);
        filter.put("source", "sdk");
        return this.currentClientsCount(filter);
    }

    public Map<String, Connection> currentClients() {
        return this.connections;
    }

    public Map<String, AtomicInteger> getConnectionForClientIp() {
        return this.connectionForClientIp;
    }
}

