/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.distributed.raft;

import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.model.RestResultUtils;
import com.alibaba.nacos.core.distributed.raft.JRaftServer;
import com.alibaba.nacos.core.distributed.raft.utils.JRaftOps;
import com.alipay.sofa.jraft.CliService;
import com.alipay.sofa.jraft.Node;
import java.util.Map;
import java.util.Objects;

public class JRaftMaintainService {
    private final JRaftServer raftServer;

    public JRaftMaintainService(JRaftServer raftServer) {
        this.raftServer = raftServer;
    }

    public RestResult<String> execute(String[] args) {
        return RestResultUtils.failed((String)"not support yet");
    }

    public RestResult<String> execute(Map<String, String> args) {
        CliService cliService = this.raftServer.getCliService();
        if (args.containsKey("groupId")) {
            String groupId = args.get("groupId");
            Node node = this.raftServer.findNodeByGroup(groupId);
            return this.single(cliService, groupId, node, args);
        }
        Map<String, JRaftServer.RaftGroupTuple> tupleMap = this.raftServer.getMultiRaftGroup();
        for (Map.Entry<String, JRaftServer.RaftGroupTuple> entry : tupleMap.entrySet()) {
            Node node;
            String group = entry.getKey();
            RestResult<String> result = this.single(cliService, group, node = entry.getValue().getNode(), args);
            if (result.ok()) continue;
            return result;
        }
        return RestResultUtils.success();
    }

    private RestResult<String> single(CliService cliService, String groupId, Node node, Map<String, String> args) {
        try {
            if (node == null) {
                return RestResultUtils.failed((String)("not this raft group : " + groupId));
            }
            String command = args.get("command");
            JRaftOps ops = JRaftOps.sourceOf(command);
            if (Objects.isNull((Object)ops)) {
                return RestResultUtils.failed((String)("Not support command : " + command));
            }
            return ops.execute(cliService, groupId, node, args);
        }
        catch (Throwable ex) {
            return RestResultUtils.failed((String)ex.getMessage());
        }
    }
}

