/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.config;

import com.alibaba.nacos.common.event.ServerConfigChangeEvent;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.core.utils.Loggers;

public abstract class AbstractDynamicConfig
extends Subscriber<ServerConfigChangeEvent> {
    private final String configName;

    protected AbstractDynamicConfig(String configName) {
        this.configName = configName;
        this.resetConfig();
        NotifyCenter.registerSubscriber((Subscriber)this);
    }

    public void onEvent(ServerConfigChangeEvent event) {
        this.resetConfig();
    }

    public Class<? extends Event> subscribeType() {
        return ServerConfigChangeEvent.class;
    }

    private void resetConfig() {
        try {
            this.getConfigFromEnv();
            Loggers.CORE.info("Get {} config from env, {}", (Object)this.configName, (Object)this.printConfig());
        }
        catch (Exception e) {
            Loggers.CORE.warn("Upgrade {} config from env failed, will use old value", (Object)this.configName, (Object)e);
        }
    }

    protected abstract void getConfigFromEnv();

    protected abstract String printConfig();
}

