/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.repository.extrnal;

import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.configuration.ConditionOnExternalStorage;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.ConfigInfoTagWrapper;
import com.alibaba.nacos.config.server.model.Page;
import com.alibaba.nacos.config.server.service.datasource.DataSourceService;
import com.alibaba.nacos.config.server.service.datasource.DynamicDataSource;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoTagPersistService;
import com.alibaba.nacos.config.server.service.repository.PaginationHelper;
import com.alibaba.nacos.config.server.service.repository.RowMapperManager;
import com.alibaba.nacos.config.server.service.repository.extrnal.ExternalStoragePaginationHelperImpl;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.plugin.datasource.MapperManager;
import com.alibaba.nacos.plugin.datasource.mapper.ConfigInfoTagMapper;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.sql.Timestamp;
import java.util.Arrays;
import org.springframework.context.annotation.Conditional;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Conditional(value={ConditionOnExternalStorage.class})
@Service(value="externalConfigInfoTagPersistServiceImpl")
public class ExternalConfigInfoTagPersistServiceImpl
implements ConfigInfoTagPersistService {
    private DataSourceService dataSourceService = DynamicDataSource.getInstance().getDataSource();
    protected JdbcTemplate jt = this.dataSourceService.getJdbcTemplate();
    protected TransactionTemplate tjt = this.dataSourceService.getTransactionTemplate();
    private MapperManager mapperManager;

    public ExternalConfigInfoTagPersistServiceImpl() {
        Boolean isDataSourceLogEnable = (Boolean)EnvUtil.getProperty((String)"nacos.plugin.datasource.log.enabled", Boolean.class, (Object)false);
        this.mapperManager = MapperManager.instance((boolean)isDataSourceLogEnable);
    }

    @Override
    public <E> PaginationHelper<E> createPaginationHelper() {
        return new ExternalStoragePaginationHelperImpl(this.jt);
    }

    @Override
    public void addConfigInfo4Tag(ConfigInfo configInfo, String tag, String srcIp, String srcUser, Timestamp time, boolean notify) {
        String appNameTmp = StringUtils.isBlank((CharSequence)configInfo.getAppName()) ? "" : configInfo.getAppName();
        String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
        String tagTmp = StringUtils.isBlank((CharSequence)tag) ? "" : tag.trim();
        String md5 = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
        try {
            ConfigInfoTagMapper configInfoTagMapper = (ConfigInfoTagMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_tag");
            this.jt.update(configInfoTagMapper.insert(Arrays.asList("data_id", "group_id", "tenant_id", "tag_id", "app_name", "content", "md5", "src_ip", "src_user", "gmt_create", "gmt_modified")), new Object[]{configInfo.getDataId(), configInfo.getGroup(), tenantTmp, tagTmp, appNameTmp, configInfo.getContent(), md5, srcIp, srcUser, time, time});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void insertOrUpdateTag(ConfigInfo configInfo, String tag, String srcIp, String srcUser, Timestamp time, boolean notify) {
        try {
            this.addConfigInfo4Tag(configInfo, tag, srcIp, null, time, notify);
        }
        catch (DataIntegrityViolationException ive) {
            this.updateConfigInfo4Tag(configInfo, tag, srcIp, null, time, notify);
        }
    }

    @Override
    public boolean insertOrUpdateTagCas(ConfigInfo configInfo, String tag, String srcIp, String srcUser, Timestamp time, boolean notify) {
        try {
            this.addConfigInfo4Tag(configInfo, tag, srcIp, null, time, notify);
            return true;
        }
        catch (DataIntegrityViolationException ive) {
            return this.updateConfigInfo4TagCas(configInfo, tag, srcIp, null, time, notify);
        }
    }

    @Override
    public void removeConfigInfoTag(String dataId, String group, String tenant, String tag, String srcIp, String srcUser) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String tagTmp = StringUtils.isBlank((CharSequence)tag) ? "" : tag;
        try {
            ConfigInfoTagMapper configInfoTagMapper = (ConfigInfoTagMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_tag");
            this.jt.update(configInfoTagMapper.delete(Arrays.asList("data_id", "group_id", "tenant_id", "tag_id")), new Object[]{dataId, group, tenantTmp, tagTmp});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void updateConfigInfo4Tag(ConfigInfo configInfo, String tag, String srcIp, String srcUser, Timestamp time, boolean notify) {
        String appNameTmp = StringUtils.isBlank((CharSequence)configInfo.getAppName()) ? "" : configInfo.getAppName();
        String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
        String tagTmp = StringUtils.isBlank((CharSequence)tag) ? "" : tag.trim();
        try {
            String md5 = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
            ConfigInfoTagMapper configInfoTagMapper = (ConfigInfoTagMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_tag");
            this.jt.update(configInfoTagMapper.update(Arrays.asList("content", "md5", "src_ip", "src_user", "gmt_modified", "app_name"), Arrays.asList("data_id", "group_id", "tenant_id", "tag_id")), new Object[]{configInfo.getContent(), md5, srcIp, srcUser, time, appNameTmp, configInfo.getDataId(), configInfo.getGroup(), tenantTmp, tagTmp});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public boolean updateConfigInfo4TagCas(ConfigInfo configInfo, String tag, String srcIp, String srcUser, Timestamp time, boolean notify) {
        String appNameTmp = StringUtils.isBlank((CharSequence)configInfo.getAppName()) ? "" : configInfo.getAppName();
        String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
        String tagTmp = StringUtils.isBlank((CharSequence)tag) ? "" : tag.trim();
        try {
            String md5 = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
            ConfigInfoTagMapper configInfoTagMapper = (ConfigInfoTagMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_tag");
            return this.jt.update(configInfoTagMapper.updateConfigInfo4TagCas(), new Object[]{configInfo.getContent(), md5, srcIp, srcUser, time, appNameTmp, configInfo.getDataId(), configInfo.getGroup(), tenantTmp, tagTmp, configInfo.getMd5()}) > 0;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public ConfigInfoTagWrapper findConfigInfo4Tag(String dataId, String group, String tenant, String tag) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String tagTmp = StringUtils.isBlank((CharSequence)tag) ? "" : tag.trim();
        try {
            ConfigInfoTagMapper configInfoTagMapper = (ConfigInfoTagMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_tag");
            return (ConfigInfoTagWrapper)this.jt.queryForObject(configInfoTagMapper.select(Arrays.asList("id", "data_id", "group_id", "tenant_id", "tag_id", "app_name", "content"), Arrays.asList("data_id", "group_id", "tenant_id", "tag_id")), new Object[]{dataId, group, tenantTmp, tagTmp}, (RowMapper)RowMapperManager.CONFIG_INFO_TAG_WRAPPER_ROW_MAPPER);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public int configInfoTagCount() {
        ConfigInfoTagMapper configInfoTagMapper = (ConfigInfoTagMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_tag");
        String sql = configInfoTagMapper.count(null);
        Integer result = (Integer)this.jt.queryForObject(sql, Integer.class);
        if (result == null) {
            throw new IllegalArgumentException("configInfoBetaCount error");
        }
        return result;
    }

    @Override
    public Page<ConfigInfoTagWrapper> findAllConfigInfoTagForDumpAll(int pageNo, int pageSize) {
        int startRow = (pageNo - 1) * pageSize;
        ConfigInfoTagMapper configInfoTagMapper = (ConfigInfoTagMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_tag");
        String sqlCountRows = configInfoTagMapper.count(null);
        String sqlFetchRows = configInfoTagMapper.findAllConfigInfoTagForDumpAllFetchRows(startRow, pageSize);
        PaginationHelper<ConfigInfoTagWrapper> helper = this.createPaginationHelper();
        try {
            return helper.fetchPageLimit(sqlCountRows, sqlFetchRows, new Object[0], pageNo, pageSize, RowMapperManager.CONFIG_INFO_TAG_WRAPPER_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }
}

