/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.dump;

import com.alibaba.nacos.common.utils.Observable;
import com.alibaba.nacos.common.utils.Observer;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.common.utils.ThreadUtils;
import com.alibaba.nacos.config.server.configuration.ConditionOnEmbeddedStorage;
import com.alibaba.nacos.config.server.service.dump.DumpService;
import com.alibaba.nacos.config.server.service.repository.CommonPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoAggrPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoBetaPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoTagPersistService;
import com.alibaba.nacos.config.server.service.repository.HistoryConfigInfoPersistService;
import com.alibaba.nacos.config.server.service.sql.EmbeddedStorageContextUtils;
import com.alibaba.nacos.consistency.ProtocolMetaData;
import com.alibaba.nacos.consistency.cp.CPProtocol;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.core.distributed.ProtocolManager;
import com.alibaba.nacos.core.utils.GlobalExecutor;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PostConstruct;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={ConditionOnEmbeddedStorage.class})
@Component
public class EmbeddedDumpService
extends DumpService {
    private final ProtocolManager protocolManager;
    final String[] retryMessages = new String[]{"The conformance protocol is temporarily unavailable for reading"};
    final String[] errorMessages = new String[]{"FSMCaller is overload.", "STATE_ERROR"};

    public EmbeddedDumpService(ConfigInfoPersistService configInfoPersistService, CommonPersistService commonPersistService, HistoryConfigInfoPersistService historyConfigInfoPersistService, ConfigInfoAggrPersistService configInfoAggrPersistService, ConfigInfoBetaPersistService configInfoBetaPersistService, ConfigInfoTagPersistService configInfoTagPersistService, ServerMemberManager memberManager, ProtocolManager protocolManager) {
        super(configInfoPersistService, commonPersistService, historyConfigInfoPersistService, configInfoAggrPersistService, configInfoBetaPersistService, configInfoTagPersistService, memberManager);
        this.protocolManager = protocolManager;
    }

    @Override
    @PostConstruct
    protected void init() throws Throwable {
        if (EnvUtil.getStandaloneMode()) {
            this.dumpOperate(this.processor, this.dumpAllProcessor, this.dumpAllBetaProcessor, this.dumpAllTagProcessor);
            return;
        }
        final CPProtocol protocol = this.protocolManager.getCpProtocol();
        final AtomicReference<Object> errorReference = new AtomicReference<Object>(null);
        final CountDownLatch waitDumpFinish = new CountDownLatch(1);
        Observer observer = new Observer(){

            public void update(Observable o) {
                if (!(o instanceof ProtocolMetaData.ValueItem)) {
                    return;
                }
                Object arg = ((ProtocolMetaData.ValueItem)o).getData();
                GlobalExecutor.executeByCommon(() -> {
                    if (Objects.isNull(arg)) {
                        return;
                    }
                    EmbeddedStorageContextUtils.putExtendInfo("00--0-read-join-0--00", "true");
                    boolean canEnd = false;
                    while (true) {
                        block4: {
                            try {
                                EmbeddedDumpService.this.dumpOperate(EmbeddedDumpService.this.processor, EmbeddedDumpService.this.dumpAllProcessor, EmbeddedDumpService.this.dumpAllBetaProcessor, EmbeddedDumpService.this.dumpAllTagProcessor);
                                protocol.protocolMetaData().unSubscribe("nacos_config", "leader", (Observer)this);
                                canEnd = true;
                            }
                            catch (Throwable ex) {
                                if (EmbeddedDumpService.this.shouldRetry(ex)) break block4;
                                errorReference.set(ex);
                                canEnd = true;
                            }
                        }
                        if (canEnd) break;
                        ThreadUtils.sleep((long)500L);
                    }
                    ThreadUtils.countDown((CountDownLatch)waitDumpFinish);
                    EmbeddedStorageContextUtils.cleanAllContext();
                });
            }
        };
        protocol.protocolMetaData().subscribe("nacos_config", "leader", observer);
        ThreadUtils.latchAwait((CountDownLatch)waitDumpFinish);
        Throwable ex = errorReference.get();
        if (Objects.nonNull(ex)) {
            throw ex;
        }
    }

    private boolean shouldRetry(Throwable ex) {
        String errMsg = ex.getMessage();
        for (String failedMsg : this.errorMessages) {
            if (!StringUtils.containsIgnoreCase((CharSequence)errMsg, (CharSequence)failedMsg)) continue;
            return false;
        }
        for (String retryMsg : this.retryMessages) {
            if (!StringUtils.containsIgnoreCase((CharSequence)errMsg, (CharSequence)retryMsg)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean canExecute() {
        if (EnvUtil.getStandaloneMode()) {
            return true;
        }
        CPProtocol protocol = this.protocolManager.getCpProtocol();
        return protocol.isLeader("nacos_config");
    }
}

