/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.utils;

import com.alibaba.nacos.client.env.NacosClientProperties;
import com.alibaba.nacos.client.utils.AppNameUtils;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.client.utils.TemplateUtils;
import com.alibaba.nacos.client.utils.TenantUtil;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.common.utils.VersionUtils;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class ParamUtil {
    private static final Logger LOGGER = LogUtils.logger(ParamUtil.class);
    public static final boolean USE_ENDPOINT_PARSING_RULE_DEFAULT_VALUE = true;
    private static final Pattern PATTERN = Pattern.compile("\\$\\{[^}]+\\}");
    private static String defaultContextPath;
    private static String defaultNodesPath;
    private static String appKey;
    private static String appName;
    private static final String DEFAULT_SERVER_PORT = "8848";
    private static String serverPort;
    private static String clientVersion;
    private static int connectTimeout;
    private static double perTaskConfigSize;
    private static final String NACOS_CLIENT_APP_KEY = "nacos.client.appKey";
    private static final String BLANK_STR = "";
    private static final String NACOS_CLIENT_CONTEXTPATH_KEY = "nacos.client.contextPath";
    private static final String DEFAULT_NACOS_CLIENT_CONTEXTPATH = "nacos";
    private static final String NACOS_SERVER_PORT_KEY = "nacos.server.port";
    private static final String NACOS_CONNECT_TIMEOUT_KEY = "NACOS.CONNECT.TIMEOUT";
    private static final String DEFAULT_NACOS_CONNECT_TIMEOUT = "1000";
    private static final String PER_TASK_CONFIG_SIZE_KEY = "PER_TASK_CONFIG_SIZE";
    private static final String DEFAULT_PER_TASK_CONFIG_SIZE_KEY = "3000";

    public static String getAppKey() {
        return appKey;
    }

    public static void setAppKey(String appKey) {
        ParamUtil.appKey = appKey;
    }

    public static String getAppName() {
        return appName;
    }

    public static void setAppName(String appName) {
        ParamUtil.appName = appName;
    }

    public static String getDefaultContextPath() {
        return defaultContextPath;
    }

    public static void setDefaultContextPath(String defaultContextPath) {
        ParamUtil.defaultContextPath = defaultContextPath;
    }

    public static String getClientVersion() {
        return clientVersion;
    }

    public static void setClientVersion(String clientVersion) {
        ParamUtil.clientVersion = clientVersion;
    }

    public static int getConnectTimeout() {
        return connectTimeout;
    }

    public static void setConnectTimeout(int connectTimeout) {
        ParamUtil.connectTimeout = connectTimeout;
    }

    public static double getPerTaskConfigSize() {
        return perTaskConfigSize;
    }

    public static void setPerTaskConfigSize(double perTaskConfigSize) {
        ParamUtil.perTaskConfigSize = perTaskConfigSize;
    }

    public static String getDefaultServerPort() {
        return serverPort;
    }

    public static String getDefaultNodesPath() {
        return defaultNodesPath;
    }

    public static void setDefaultNodesPath(String defaultNodesPath) {
        ParamUtil.defaultNodesPath = defaultNodesPath;
    }

    public static String parseNamespace(NacosClientProperties properties) {
        String namespaceTmp = null;
        String isUseCloudNamespaceParsing = properties.getProperty("isUseCloudNamespaceParsing", properties.getProperty("nacos.use.cloud.namespace.parsing", String.valueOf(true)));
        if (Boolean.parseBoolean(isUseCloudNamespaceParsing)) {
            namespaceTmp = TenantUtil.getUserTenantForAcm();
            namespaceTmp = TemplateUtils.stringBlankAndThenExecute(namespaceTmp, () -> {
                String namespace = properties.getProperty("ALIBABA_ALIWARE_NAMESPACE");
                return StringUtils.isNotBlank((String)namespace) ? namespace : BLANK_STR;
            });
        }
        if (StringUtils.isBlank((CharSequence)namespaceTmp)) {
            namespaceTmp = properties.getProperty("namespace");
        }
        return StringUtils.isNotBlank((String)namespaceTmp) ? namespaceTmp.trim() : BLANK_STR;
    }

    public static String parsingEndpointRule(String endpointUrl) {
        String endpointUrlSource;
        if (endpointUrl == null || !PATTERN.matcher(endpointUrl).find()) {
            String endpointUrlSource2 = NacosClientProperties.PROTOTYPE.getProperty("ALIBABA_ALIWARE_ENDPOINT_URL");
            if (StringUtils.isNotBlank((String)endpointUrlSource2)) {
                endpointUrl = endpointUrlSource2;
            }
            return StringUtils.isNotBlank((String)endpointUrl) ? endpointUrl : BLANK_STR;
        }
        endpointUrl = endpointUrl.substring(endpointUrl.indexOf("${") + 2, endpointUrl.lastIndexOf("}"));
        int defStartOf = endpointUrl.indexOf(":");
        String defaultEndpointUrl = null;
        if (defStartOf != -1) {
            defaultEndpointUrl = endpointUrl.substring(defStartOf + 1);
            endpointUrl = endpointUrl.substring(0, defStartOf);
        }
        if (StringUtils.isBlank((CharSequence)(endpointUrlSource = TemplateUtils.stringBlankAndThenExecute(NacosClientProperties.PROTOTYPE.getProperty(endpointUrl, System.getenv(endpointUrl)), () -> NacosClientProperties.PROTOTYPE.getProperty("ALIBABA_ALIWARE_ENDPOINT_URL"))))) {
            if (StringUtils.isNotBlank((String)defaultEndpointUrl)) {
                endpointUrl = defaultEndpointUrl;
            }
        } else {
            endpointUrl = endpointUrlSource;
        }
        return StringUtils.isNotBlank((String)endpointUrl) ? endpointUrl : BLANK_STR;
    }

    static {
        defaultNodesPath = "serverlist";
        clientVersion = "unknown";
        perTaskConfigSize = 3000.0;
        appKey = NacosClientProperties.PROTOTYPE.getProperty(NACOS_CLIENT_APP_KEY, BLANK_STR);
        defaultContextPath = NacosClientProperties.PROTOTYPE.getProperty(NACOS_CLIENT_CONTEXTPATH_KEY, DEFAULT_NACOS_CLIENT_CONTEXTPATH);
        appName = AppNameUtils.getAppName();
        serverPort = NacosClientProperties.PROTOTYPE.getProperty(NACOS_SERVER_PORT_KEY, DEFAULT_SERVER_PORT);
        LOGGER.info("[settings] [req-serv] nacos-server port:{}", (Object)serverPort);
        String tmp = DEFAULT_NACOS_CONNECT_TIMEOUT;
        try {
            tmp = NacosClientProperties.PROTOTYPE.getProperty(NACOS_CONNECT_TIMEOUT_KEY, DEFAULT_NACOS_CONNECT_TIMEOUT);
            connectTimeout = Integer.parseInt(tmp);
        }
        catch (NumberFormatException e) {
            String msg = "[http-client] invalid connect timeout:" + tmp;
            LOGGER.error("[settings] " + msg, (Throwable)e);
            throw new IllegalArgumentException(msg, e);
        }
        LOGGER.info("[settings] [http-client] connect timeout:{}", (Object)connectTimeout);
        clientVersion = VersionUtils.version;
        try {
            perTaskConfigSize = Double.parseDouble(NacosClientProperties.PROTOTYPE.getProperty(PER_TASK_CONFIG_SIZE_KEY, DEFAULT_PER_TASK_CONFIG_SIZE_KEY));
            LOGGER.info("PER_TASK_CONFIG_SIZE: {}", (Object)perTaskConfigSize);
        }
        catch (Throwable t) {
            LOGGER.error("[PER_TASK_CONFIG_SIZE] PER_TASK_CONFIG_SIZE invalid", t);
        }
    }
}

