/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.utils;

import com.alibaba.nacos.api.selector.ExpressionSelector;
import com.alibaba.nacos.api.selector.NoneSelector;
import com.alibaba.nacos.api.selector.SelectorType;
import com.alibaba.nacos.client.env.NacosClientProperties;
import com.alibaba.nacos.client.naming.utils.UtilAndComs;
import com.alibaba.nacos.client.utils.ContextPathUtil;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.client.utils.ParamUtil;
import com.alibaba.nacos.client.utils.TemplateUtils;
import com.alibaba.nacos.client.utils.TenantUtil;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;

public class InitUtils {
    private static final String DEFAULT_END_POINT_PORT = "8080";

    public static String initNamespaceForNaming(NacosClientProperties properties) {
        String tmpNamespace = null;
        String isUseCloudNamespaceParsing = properties.getProperty("isUseCloudNamespaceParsing", properties.getProperty("nacos.use.cloud.namespace.parsing", String.valueOf(true)));
        if (Boolean.parseBoolean(isUseCloudNamespaceParsing)) {
            tmpNamespace = TenantUtil.getUserTenantForAns();
            LogUtils.NAMING_LOGGER.info("initializer namespace from System Property : {}", (Object)tmpNamespace);
            tmpNamespace = TemplateUtils.stringEmptyAndThenExecute(tmpNamespace, () -> {
                String namespace = properties.getProperty("ALIBABA_ALIWARE_NAMESPACE");
                LogUtils.NAMING_LOGGER.info("initializer namespace from System Environment :" + namespace);
                return namespace;
            });
        }
        if (StringUtils.isEmpty((String)(tmpNamespace = TemplateUtils.stringEmptyAndThenExecute(tmpNamespace, () -> {
            String namespace = properties.getProperty("namespace");
            LogUtils.NAMING_LOGGER.info("initializer namespace from System Property :" + namespace);
            return namespace;
        })))) {
            tmpNamespace = properties.getProperty("namespace");
        }
        tmpNamespace = TemplateUtils.stringEmptyAndThenExecute(tmpNamespace, () -> "public");
        return tmpNamespace;
    }

    public static void initWebRootContext(NacosClientProperties properties) {
        String webContext = properties.getProperty("contextPath");
        TemplateUtils.stringNotEmptyAndThenExecute(webContext, () -> {
            UtilAndComs.webContext = ContextPathUtil.normalizeContextPath(webContext);
            UtilAndComs.nacosUrlBase = UtilAndComs.webContext + "/v1/ns";
            UtilAndComs.nacosUrlInstance = UtilAndComs.nacosUrlBase + "/instance";
        });
    }

    public static String initEndpoint(NacosClientProperties properties) {
        String endpointUrl;
        if (properties == null) {
            return "";
        }
        String isUseEndpointRuleParsing = properties.getProperty("isUseEndpointParsingRule", properties.getProperty("nacos.use.endpoint.parsing.rule", String.valueOf(true)));
        boolean isUseEndpointParsingRule = Boolean.parseBoolean(isUseEndpointRuleParsing);
        if (isUseEndpointParsingRule) {
            endpointUrl = ParamUtil.parsingEndpointRule(properties.getProperty("endpoint"));
            if (StringUtils.isBlank((CharSequence)endpointUrl)) {
                return "";
            }
        } else {
            endpointUrl = properties.getProperty("endpoint");
        }
        if (StringUtils.isBlank((CharSequence)endpointUrl)) {
            return "";
        }
        String endpointPort = TemplateUtils.stringEmptyAndThenExecute(properties.getProperty("ALIBABA_ALIWARE_ENDPOINT_PORT"), () -> properties.getProperty("endpointPort"));
        endpointPort = TemplateUtils.stringEmptyAndThenExecute(endpointPort, () -> DEFAULT_END_POINT_PORT);
        return endpointUrl + ":" + endpointPort;
    }

    public static void initSerialization() {
        JacksonUtils.registerSubtype(NoneSelector.class, (String)SelectorType.none.name());
        JacksonUtils.registerSubtype(ExpressionSelector.class, (String)SelectorType.label.name());
    }
}

