/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.logging;

import com.alibaba.nacos.client.env.NacosClientProperties;
import com.alibaba.nacos.common.utils.ConvertUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import java.io.File;

public abstract class AbstractNacosLogging {
    private static final String NACOS_LOGGING_CONFIG_PROPERTY = "nacos.logging.config";
    private static final String NACOS_LOGGING_DEFAULT_CONFIG_ENABLED_PROPERTY = "nacos.logging.default.config.enabled";
    private static final String NACOS_LOGGING_PATH_DIR = "logs";

    protected String getLocation(String defaultLocation) {
        String location = NacosClientProperties.PROTOTYPE.getProperty(NACOS_LOGGING_CONFIG_PROPERTY);
        if (StringUtils.isBlank((CharSequence)location)) {
            if (this.isDefaultConfigEnabled()) {
                return defaultLocation;
            }
            return null;
        }
        return location;
    }

    private boolean isDefaultConfigEnabled() {
        String property = NacosClientProperties.PROTOTYPE.getProperty(NACOS_LOGGING_DEFAULT_CONFIG_ENABLED_PROPERTY);
        return property == null || ConvertUtils.toBoolean((String)property);
    }

    public abstract void loadConfiguration();

    static {
        String loggingPath = NacosClientProperties.PROTOTYPE.getProperty("JM.LOG.PATH");
        if (StringUtils.isBlank((CharSequence)loggingPath)) {
            String userHome = NacosClientProperties.PROTOTYPE.getProperty("user.home");
            NacosClientProperties.PROTOTYPE.setProperty("JM.LOG.PATH", userHome + File.separator + NACOS_LOGGING_PATH_DIR);
        }
    }
}

