/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.config.impl;

import com.alibaba.nacos.api.config.ConfigChangeItem;
import com.alibaba.nacos.api.config.listener.ConfigChangeParser;
import com.alibaba.nacos.client.config.impl.PropertiesChangeParser;
import com.alibaba.nacos.client.config.impl.YmlChangeParser;
import com.alibaba.nacos.common.spi.NacosServiceLoader;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ConfigChangeHandler {
    private final List<ConfigChangeParser> parserList = new LinkedList<ConfigChangeParser>();

    private ConfigChangeHandler() {
        Collection loader = NacosServiceLoader.load(ConfigChangeParser.class);
        Iterator itr = loader.iterator();
        while (itr.hasNext()) {
            this.parserList.add((ConfigChangeParser)itr.next());
        }
        this.parserList.add(new PropertiesChangeParser());
        this.parserList.add(new YmlChangeParser());
    }

    public static ConfigChangeHandler getInstance() {
        return ConfigChangeHandlerHolder.INSTANCE;
    }

    public Map<String, ConfigChangeItem> parseChangeData(String oldContent, String newContent, String type) throws IOException {
        for (ConfigChangeParser changeParser : this.parserList) {
            if (!changeParser.isResponsibleFor(type)) continue;
            return changeParser.doParse(oldContent, newContent, type);
        }
        return Collections.emptyMap();
    }

    private static class ConfigChangeHandlerHolder {
        private static final ConfigChangeHandler INSTANCE = new ConfigChangeHandler();

        private ConfigChangeHandlerHolder() {
        }
    }
}

