/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.remote.gprc.redo;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.client.naming.remote.gprc.NamingGrpcClientProxy;
import com.alibaba.nacos.client.naming.remote.gprc.redo.NamingGrpcRedoService;
import com.alibaba.nacos.client.naming.remote.gprc.redo.data.InstanceRedoData;
import com.alibaba.nacos.client.naming.remote.gprc.redo.data.RedoData;
import com.alibaba.nacos.client.naming.remote.gprc.redo.data.SubscriberRedoData;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.common.task.AbstractExecuteTask;

public class RedoScheduledTask
extends AbstractExecuteTask {
    private final NamingGrpcClientProxy clientProxy;
    private final NamingGrpcRedoService redoService;

    public RedoScheduledTask(NamingGrpcClientProxy clientProxy, NamingGrpcRedoService redoService) {
        this.clientProxy = clientProxy;
        this.redoService = redoService;
    }

    public void run() {
        if (!this.redoService.isConnected()) {
            LogUtils.NAMING_LOGGER.warn("Grpc Connection is disconnect, skip current redo task");
            return;
        }
        try {
            this.redoForInstances();
            this.redoForSubscribes();
        }
        catch (Exception e) {
            LogUtils.NAMING_LOGGER.warn("Redo task run with unexpected exception: ", (Throwable)e);
        }
    }

    private void redoForInstances() {
        for (InstanceRedoData each : this.redoService.findInstanceRedoData()) {
            try {
                this.redoForInstance(each);
            }
            catch (NacosException e) {
                LogUtils.NAMING_LOGGER.error("Redo instance operation {} for {}@@{} failed. ", new Object[]{each.getRedoType(), each.getGroupName(), each.getServiceName(), e});
            }
        }
    }

    private void redoForInstance(InstanceRedoData redoData) throws NacosException {
        RedoData.RedoType redoType = redoData.getRedoType();
        String serviceName = redoData.getServiceName();
        String groupName = redoData.getGroupName();
        LogUtils.NAMING_LOGGER.info("Redo instance operation {} for {}@@{}", new Object[]{redoType, groupName, serviceName});
        switch (redoType) {
            case REGISTER: {
                if (this.isClientDisabled()) {
                    return;
                }
                this.clientProxy.doRegisterService(serviceName, groupName, (Instance)redoData.get());
                break;
            }
            case UNREGISTER: {
                if (this.isClientDisabled()) {
                    return;
                }
                this.clientProxy.doDeregisterService(serviceName, groupName, (Instance)redoData.get());
                break;
            }
            case REMOVE: {
                this.redoService.removeInstanceForRedo(serviceName, groupName);
                break;
            }
        }
    }

    private void redoForSubscribes() {
        for (SubscriberRedoData each : this.redoService.findSubscriberRedoData()) {
            try {
                this.redoForSubscribe(each);
            }
            catch (NacosException e) {
                LogUtils.NAMING_LOGGER.error("Redo subscriber operation {} for {}@@{}#{} failed. ", new Object[]{each.getRedoType(), each.getGroupName(), each.getServiceName(), each.get(), e});
            }
        }
    }

    private void redoForSubscribe(SubscriberRedoData redoData) throws NacosException {
        RedoData.RedoType redoType = redoData.getRedoType();
        String serviceName = redoData.getServiceName();
        String groupName = redoData.getGroupName();
        String cluster = (String)redoData.get();
        LogUtils.NAMING_LOGGER.info("Redo subscriber operation {} for {}@@{}#{}", new Object[]{redoType, groupName, serviceName, cluster});
        switch (redoData.getRedoType()) {
            case REGISTER: {
                if (this.isClientDisabled()) {
                    return;
                }
                this.clientProxy.doSubscribe(serviceName, groupName, cluster);
                break;
            }
            case UNREGISTER: {
                if (this.isClientDisabled()) {
                    return;
                }
                this.clientProxy.doUnsubscribe(serviceName, groupName, cluster);
                break;
            }
            case REMOVE: {
                this.redoService.removeSubscriberForRedo(redoData.getServiceName(), redoData.getGroupName(), (String)redoData.get());
                break;
            }
        }
    }

    private boolean isClientDisabled() {
        return !this.clientProxy.isEnable();
    }
}

