/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.address.controller;

import com.alibaba.nacos.address.component.AddressServerGeneratorManager;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.naming.core.v2.ServiceManager;
import com.alibaba.nacos.naming.core.v2.index.ServiceStorage;
import com.alibaba.nacos.naming.core.v2.metadata.ClusterMetadata;
import com.alibaba.nacos.naming.core.v2.metadata.NamingMetadataManager;
import com.alibaba.nacos.naming.core.v2.metadata.ServiceMetadata;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.utils.ServiceUtil;
import java.util.Optional;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ServerListController {
    private final AddressServerGeneratorManager addressServerBuilderManager;
    private final NamingMetadataManager metadataManager;
    private final ServiceStorage serviceStorage;

    public ServerListController(AddressServerGeneratorManager addressServerBuilderManager, NamingMetadataManager metadataManager, ServiceStorage serviceStorage) {
        this.addressServerBuilderManager = addressServerBuilderManager;
        this.metadataManager = metadataManager;
        this.serviceStorage = serviceStorage;
    }

    @RequestMapping(value={"/{product}/{cluster}"}, method={RequestMethod.GET})
    public ResponseEntity<String> getCluster(@PathVariable String product, @PathVariable String cluster) {
        String productName = this.addressServerBuilderManager.generateProductName(product);
        String serviceName = this.addressServerBuilderManager.generateNacosServiceName(productName);
        String serviceWithoutGroup = NamingUtils.getServiceName((String)serviceName);
        String groupName = NamingUtils.getGroupName((String)serviceName);
        Optional service = ServiceManager.getInstance().getSingletonIfExist("public", groupName, serviceWithoutGroup);
        if (!service.isPresent()) {
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)("product=" + product + " not found."));
        }
        ClusterMetadata metadata = (ClusterMetadata)this.metadataManager.getServiceMetadata((Service)service.get()).orElse(new ServiceMetadata()).getClusters().get(cluster);
        if (null == metadata) {
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)("product=" + product + ",cluster=" + cluster + " not found."));
        }
        ServiceInfo serviceInfo = this.serviceStorage.getData((Service)service.get());
        serviceInfo = ServiceUtil.selectInstances((ServiceInfo)serviceInfo, (String)cluster, (boolean)false);
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.addressServerBuilderManager.generateResponseIps(serviceInfo.getHosts()));
    }
}

