/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.address.controller;

import com.alibaba.nacos.address.component.AddressServerGeneratorManager;
import com.alibaba.nacos.address.component.AddressServerManager;
import com.alibaba.nacos.address.misc.Loggers;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.healthcheck.AbstractHealthChecker;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.common.utils.InternetAddressUtil;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.naming.core.ClusterOperator;
import com.alibaba.nacos.naming.core.InstanceOperator;
import com.alibaba.nacos.naming.core.v2.ServiceManager;
import com.alibaba.nacos.naming.core.v2.metadata.ClusterMetadata;
import com.alibaba.nacos.naming.core.v2.metadata.NamingMetadataManager;
import com.alibaba.nacos.naming.core.v2.metadata.ServiceMetadata;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import java.util.List;
import java.util.Optional;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/nacos/v1/as/nodes"})
public class AddressServerClusterController {
    private final InstanceOperator instanceOperator;
    private final NamingMetadataManager metadataManager;
    private final ClusterOperator clusterOperator;
    private final AddressServerManager addressServerManager;
    private final AddressServerGeneratorManager addressServerGeneratorManager;

    public AddressServerClusterController(InstanceOperator instanceOperator, NamingMetadataManager metadataManager, ClusterOperator clusterOperator, AddressServerManager addressServerManager, AddressServerGeneratorManager addressServerGeneratorManager) {
        this.instanceOperator = instanceOperator;
        this.metadataManager = metadataManager;
        this.clusterOperator = clusterOperator;
        this.addressServerManager = addressServerManager;
        this.addressServerGeneratorManager = addressServerGeneratorManager;
    }

    @RequestMapping(value={""}, method={RequestMethod.POST})
    public ResponseEntity<String> postCluster(@RequestParam(required=false) String product, @RequestParam(required=false) String cluster, @RequestParam(name="ips") String ips) {
        ResponseEntity responseEntity;
        String productName = this.addressServerGeneratorManager.generateProductName(product);
        String clusterName = this.addressServerManager.getDefaultClusterNameIfEmpty(cluster);
        String rawProductName = this.addressServerManager.getRawProductName(product);
        String rawClusterName = this.addressServerManager.getRawClusterName(cluster);
        Loggers.ADDRESS_LOGGER.info("put cluster node,the cluster name is " + cluster + "; the product name=" + product + "; the ip list=" + ips);
        try {
            String serviceName = this.addressServerGeneratorManager.generateNacosServiceName(productName);
            Result result = this.registerCluster(serviceName, rawProductName, clusterName, ips);
            responseEntity = InternetAddressUtil.checkOK((String)result.getCheckResult()) ? ResponseEntity.ok((Object)("product=" + rawProductName + ",cluster=" + rawClusterName + "; put success with size=" + result.getSize())) : ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)result.getCheckResult());
        }
        catch (Exception e) {
            responseEntity = ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)e.getMessage());
        }
        return responseEntity;
    }

    private Result registerCluster(String serviceName, String productName, String clusterName, String ips) throws NacosException {
        String[] ipArray;
        String checkResult;
        String serviceWithoutGroup = NamingUtils.getServiceName((String)serviceName);
        String groupName = NamingUtils.getGroupName((String)serviceName);
        Service service = Service.newService((String)"public", (String)groupName, (String)serviceWithoutGroup, (boolean)false);
        service = ServiceManager.getInstance().getSingleton(service);
        if (service.isEphemeral()) {
            return new Result(String.format("Service %s is ephemeral service, can't use as address server", serviceName), 0);
        }
        ServiceMetadata serviceMetadata = this.metadataManager.getServiceMetadata(service).orElse(new ServiceMetadata());
        if (!serviceMetadata.getClusters().containsKey(clusterName)) {
            ClusterMetadata metadata = new ClusterMetadata();
            metadata.setHealthyCheckType("NONE");
            metadata.setHealthChecker((AbstractHealthChecker)new AbstractHealthChecker.None());
            this.clusterOperator.updateClusterMetadata("public", serviceName, clusterName, metadata);
        }
        if (InternetAddressUtil.checkOK((String)(checkResult = InternetAddressUtil.checkIPs((String[])(ipArray = this.addressServerManager.splitIps(ips)))))) {
            List<Instance> instanceList = this.addressServerGeneratorManager.generateInstancesByIps(serviceName, productName, clusterName, ipArray);
            for (Instance instance : instanceList) {
                this.instanceOperator.registerInstance("public", serviceName, instance);
            }
        }
        return new Result(checkResult, ipArray.length);
    }

    @RequestMapping(value={""}, method={RequestMethod.DELETE})
    public ResponseEntity<String> deleteCluster(@RequestParam(required=false) String product, @RequestParam(required=false) String cluster, @RequestParam String ips) {
        String productName = this.addressServerGeneratorManager.generateProductName(product);
        String clusterName = this.addressServerManager.getDefaultClusterNameIfEmpty(cluster);
        String rawProductName = this.addressServerManager.getRawProductName(product);
        String rawClusterName = this.addressServerManager.getRawClusterName(cluster);
        ResponseEntity responseEntity = ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)("product=" + rawProductName + ", cluster=" + rawClusterName + " delete success."));
        try {
            String serviceName = this.addressServerGeneratorManager.generateNacosServiceName(productName);
            String serviceWithoutGroup = NamingUtils.getServiceName((String)serviceName);
            String groupName = NamingUtils.getGroupName((String)serviceName);
            Optional service = ServiceManager.getInstance().getSingletonIfExist("public", groupName, serviceWithoutGroup);
            if (!service.isPresent()) {
                return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)("product=" + rawProductName + " not found."));
            }
            if (StringUtils.isBlank((CharSequence)ips)) {
                return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)"ips must not be empty.");
            }
            String[] ipArray = this.addressServerManager.splitIps(ips);
            String checkResult = InternetAddressUtil.checkIPs((String[])ipArray);
            if (InternetAddressUtil.checkOK((String)checkResult)) {
                List<Instance> instanceList = this.addressServerGeneratorManager.generateInstancesByIps(serviceName, rawProductName, clusterName, ipArray);
                for (Instance each : instanceList) {
                    this.instanceOperator.removeInstance("public", serviceName, each);
                }
            } else {
                responseEntity = ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)checkResult);
            }
        }
        catch (Exception e) {
            responseEntity = ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)e.getCause());
        }
        return responseEntity;
    }

    private class Result {
        private final String checkResult;
        private final int size;

        public Result(String checkResult, int size) {
            this.checkResult = checkResult;
            this.size = size;
        }

        public String getCheckResult() {
            return this.checkResult;
        }

        public int getSize() {
            return this.size;
        }
    }
}

