/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.echo.slack;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.config.OkHttp3ClientConfiguration;
import com.netflix.spinnaker.echo.api.Notification;
import com.netflix.spinnaker.echo.controller.EchoResponse;
import com.netflix.spinnaker.echo.notification.InteractiveNotificationService;
import com.netflix.spinnaker.echo.notification.NotificationTemplateEngine;
import com.netflix.spinnaker.echo.slack.SlackAppService;
import com.netflix.spinnaker.echo.slack.SlackNotificationService;
import com.netflix.spinnaker.kork.retrofit.ErrorHandlingExecutorCallAdapterFactory;
import com.netflix.spinnaker.kork.retrofit.Retrofit2SyncCall;
import com.netflix.spinnaker.kork.retrofit.util.RetrofitUtils;
import com.netflix.spinnaker.kork.web.exceptions.InvalidRequestException;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Map;
import java.util.Optional;
import okhttp3.ResponseBody;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;
import retrofit2.http.Body;
import retrofit2.http.POST;
import retrofit2.http.Path;

@Component
@ConditionalOnProperty(value={"slack.enabled"})
public class SlackInteractiveNotificationService
extends SlackNotificationService
implements InteractiveNotificationService {
    private static final String SLACK_WEBHOOK_BASE_URL = "https://hooks.slack.com";
    private SlackAppService slackAppService;
    private SlackHookService slackHookService;
    private ObjectMapper objectMapper;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Autowired
    public SlackInteractiveNotificationService(@Qualifier(value="slackAppService") SlackAppService slackAppService, NotificationTemplateEngine notificationTemplateEngine, OkHttp3ClientConfiguration okHttp3ClientConfiguration, ObjectMapper objectMapper) {
        super(slackAppService, notificationTemplateEngine);
        ObjectMapper objectMapper2;
        SlackAppService slackAppService2;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.slackAppService = slackAppService2 = slackAppService;
        this.objectMapper = objectMapper2 = objectMapper;
        CallSite callSite = IndyInterface.bootstrap("invoke", "getSlackHookService", 2, this, okHttp3ClientConfiguration);
        this.slackHookService = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    public SlackInteractiveNotificationService(@Qualifier(value="slackAppService") SlackAppService slackAppService, SlackHookService slackHookService, NotificationTemplateEngine notificationTemplateEngine, ObjectMapper objectMapper) {
        super(slackAppService, notificationTemplateEngine);
        SlackHookService slackHookService2;
        ObjectMapper objectMapper2;
        SlackAppService slackAppService2;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.slackAppService = slackAppService2 = slackAppService;
        this.objectMapper = objectMapper2 = objectMapper;
        this.slackHookService = slackHookService2 = slackHookService;
    }

    private Map parseSlackPayload(String body) {
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "startsWith", 0, body, "payload=")) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, InvalidRequestException.class, "Missing payload field in Slack callback request."));
        }
        CallSite payload = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "readValue", 0, this.objectMapper, IndyInterface.bootstrap("invoke", "decode", 0, URLDecoder.class, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "split", 0, body, "payload="), true), "UTF-8"), Map.class));
        if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "type", 0, payload), (Object)"interactive_message")) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, InvalidRequestException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "type", 0, payload)}, new String[]{"Unsupported Slack callback type: ", ""})));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "callback_id", 0, payload)) == false || IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "name", 1, IndyInterface.bootstrap("getProperty", "user", 0, payload))) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, InvalidRequestException.class, "Slack callback_id and user not present. Cannot route the request to originating Spinnaker service."));
        }
        return payload;
    }

    @Override
    public Notification.InteractiveActionCallback parseInteractionCallback(RequestEntity<String> request) {
        IndyInterface.bootstrap("invoke", "verifySignature", 0, this.slackAppService, request);
        CallSite payload = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parseSlackPayload", 2, this, IndyInterface.bootstrap("invoke", "getBody", 0, request)));
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isDebugEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "debug", 0, log, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "type", 0, payload)}, new String[]{"Received callback event from Slack of type ", ""})) : null;
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "size", 0, IndyInterface.bootstrap("getProperty", "actions", 0, payload)), (Object)1)) {
            CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isWarnEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "warn", 0, log, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "size", 0, IndyInterface.bootstrap("getProperty", "actions", 0, payload))}, new String[]{"Expected a single selected action from Slack, but received ", ""})) : null;
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "type", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "actions", 0, payload), false)), (Object)"button")) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, InvalidRequestException.class, "Spinnaker currently only supports Slack button actions."));
        }
        CallSite callSite3 = IndyInterface.bootstrap("invoke", "split", 0, IndyInterface.bootstrap("getProperty", "callback_id", 0, payload), ":");
        CallSite serviceId = IndyInterface.bootstrap("invoke", "getAt", 0, callSite3, Integer.valueOf(0));
        CallSite callbackId = IndyInterface.bootstrap("invoke", "getAt", 0, callSite3, Integer.valueOf(1));
        CallSite user = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "user", 0, payload)));
        try {
            CallSite userInfo = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getUserInfo", 0, this.slackAppService, IndyInterface.bootstrap("getProperty", "id", 0, IndyInterface.bootstrap("getProperty", "user", 0, payload))));
            user = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "email", 4, userInfo));
        }
        catch (Exception e) {
            CallSite callSite4 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isErrorEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "error", 0, log, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "user", 0, payload)), IndyInterface.bootstrap("getProperty", "id", 0, IndyInterface.bootstrap("getProperty", "user", 0, payload))}, new String[]{"Error retrieving info for Slack user ", " (", "). Falling back to username."})) : null;
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, Notification.InteractiveActionCallback.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"serviceId", serviceId, "messageId", callbackId, "user", user, "actionPerformed", IndyInterface.bootstrap("init", "<init>", 0, Notification.ButtonAction.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "actions", 0, payload), false)), "label", IndyInterface.bootstrap("getProperty", "text", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "actions", 0, payload), false)), "value", IndyInterface.bootstrap("getProperty", "value", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "actions", 0, payload), false))}))})));
    }

    @Override
    public Optional<ResponseEntity<String>> respondToCallback(RequestEntity<String> request) {
        CallSite body = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getBody", 0, request));
        CallSite payload = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parseSlackPayload", 2, this, body));
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isInfoEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "info", 0, log, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "response_url", 0, payload)}, new String[]{"Responding to Slack callback via ", ""})) : null;
        Reference selectedAction = new Reference((Object)IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "actions", 0, payload), false));
        CallSite attachment = IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "attachments", 0, IndyInterface.bootstrap("getProperty", "original_message", 0, payload)), false);
        public final class _respondToCallback_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference selectedAction;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _respondToCallback_closure1(Object _outerInstance, Object _thisObject, Reference selectedAction) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.selectedAction = reference = selectedAction;
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "type", 0, it), (Object)IndyInterface.bootstrap("getProperty", "type", 0, this.selectedAction.get())) && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "value", 0, it), (Object)IndyInterface.bootstrap("getProperty", "value", 0, this.selectedAction.get()));
            }

            @Generated
            public Object getSelectedAction() {
                return this.selectedAction.get();
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _respondToCallback_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite selectedActionText = IndyInterface.bootstrap("getProperty", "text", 0, IndyInterface.bootstrap("invoke", "find", 0, IndyInterface.bootstrap("invoke", "stream", 0, IndyInterface.bootstrap("getProperty", "actions", 0, attachment)), new _respondToCallback_closure1(this, this, selectedAction)));
        Map message = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        IndyInterface.bootstrap("invoke", "putAll", 0, message, IndyInterface.bootstrap("getProperty", "original_message", 0, payload));
        IndyInterface.bootstrap("invoke", "remove", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "attachments", 0, message), false), "actions");
        ScriptBytecodeAdapter.setProperty((Object)IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("getProperty", "text", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "attachments", 0, message), false)), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "id", 0, IndyInterface.bootstrap("getProperty", "user", 0, payload)), selectedActionText}, new String[]{"\n\nUser <@", "> clicked the *", "* action."})), null, (Object)IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "attachments", 0, message), false), (String)"text");
        CallSite responseUrl = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, URI.class, IndyInterface.bootstrap("getProperty", "response_url", 0, payload)));
        CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isInfoEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "info", 0, log, new GStringImpl(new Object[]{SLACK_WEBHOOK_BASE_URL, IndyInterface.bootstrap("getProperty", "path", 0, responseUrl), message}, new String[]{"POST ", "", ": ", ""})) : null;
        CallSite response = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "execute", 0, Retrofit2SyncCall.class, IndyInterface.bootstrap("invoke", "respondToMessage", 0, this.slackHookService, IndyInterface.bootstrap("getProperty", "path", 0, responseUrl), message)));
        CallSite callSite3 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isInfoEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "info", 0, log, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "string", 0, response)}, new String[]{"Response from Slack: ", ""})) : null;
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "empty", 0, Optional.class));
    }

    private SlackHookService getSlackHookService(OkHttp3ClientConfiguration okHttp3ClientConfiguration) {
        IndyInterface.bootstrap("invoke", "info", 0, log, "Slack hook service loaded");
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "create", 0, IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("invoke", "addConverterFactory", 0, IndyInterface.bootstrap("invoke", "addCallAdapterFactory", 0, IndyInterface.bootstrap("invoke", "client", 0, IndyInterface.bootstrap("invoke", "baseUrl", 0, IndyInterface.bootstrap("init", "<init>", 0, Retrofit.Builder.class), IndyInterface.bootstrap("invoke", "getBaseUrl", 0, RetrofitUtils.class, SLACK_WEBHOOK_BASE_URL)), IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("invoke", "createForRetrofit2", 0, okHttp3ClientConfiguration))), IndyInterface.bootstrap("invoke", "getInstance", 0, ErrorHandlingExecutorCallAdapterFactory.class)), IndyInterface.bootstrap("invoke", "create", 0, JacksonConverterFactory.class))), SlackHookService.class));
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != SlackInteractiveNotificationService.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(SlackInteractiveNotificationService.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{args});
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(SlackInteractiveNotificationService.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(SlackInteractiveNotificationService.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$2(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, SlackInteractiveNotificationService.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    public /* synthetic */ Object this$dist$get$2(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(SlackInteractiveNotificationService.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "com.netflix.spinnaker.echo.slack.SlackInteractiveNotificationService");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    public /* synthetic */ EchoResponse.Void super$2$handle(Notification notification) {
        return super.handle(notification);
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    public interface SlackHookService {
        @POST(value="{path}")
        public Call<ResponseBody> respondToMessage(@Path(value="path", encoded=true) Object var1, @Body Map var2);
    }
}

