/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.echo.notification;

import com.netflix.spinnaker.echo.api.events.Event;
import com.netflix.spinnaker.echo.api.events.EventListener;
import com.netflix.spinnaker.echo.model.pubsub.MessageDescription;
import com.netflix.spinnaker.echo.services.IgorService;
import com.netflix.spinnaker.kork.core.RetrySupport;
import com.netflix.spinnaker.kork.retrofit.Retrofit2SyncCall;
import com.netflix.spinnaker.security.AuthenticatedRequest;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import retrofit2.Call;

@ConditionalOnProperty(value={"gcb.enabled"})
@Service
public class GoogleCloudBuildNotificationAgent
implements EventListener {
    private static final Logger log = LoggerFactory.getLogger(GoogleCloudBuildNotificationAgent.class);
    private final IgorService igorService;
    private final RetrySupport retrySupport;

    public void processEvent(Event event) {
        if (event.getDetails() != null && event.getDetails().getType().equals("googleCloudBuild")) {
            MessageDescription messageDescription = (MessageDescription)event.getContent().get("messageDescription");
            this.retrySupport.retry(() -> (ResponseBody)AuthenticatedRequest.allowAnonymous(() -> (ResponseBody)Retrofit2SyncCall.execute((Call)this.igorService.updateBuildStatus(messageDescription.getSubscriptionName(), (String)messageDescription.getMessageAttributes().get("buildId"), (String)messageDescription.getMessageAttributes().get("status"), RequestBody.create((String)messageDescription.getMessagePayload(), (MediaType)MediaType.parse((String)"application/json"))))), 5, 2000L, false);
        }
    }

    public GoogleCloudBuildNotificationAgent(IgorService igorService, RetrySupport retrySupport) {
        this.igorService = igorService;
        this.retrySupport = retrySupport;
    }
}

