/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.echo.notification;

import com.netflix.spinnaker.echo.api.events.Event;
import com.netflix.spinnaker.echo.exceptions.FieldNotFoundException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

public class EventContent {
    private Event event;
    private String repo;
    private String sha;
    private String pipeline;
    private String stageName;
    private String executionId;
    private int stageIndex;

    public EventContent(Event event, String type, @Nullable String forced_repo, @Nullable String forced_sha) throws FieldNotFoundException {
        this.event = event;
        if (forced_repo != null) {
            this.repo = forced_repo;
        } else {
            this.setRepo();
        }
        if (forced_sha != null) {
            this.sha = forced_sha;
        } else {
            this.setSha();
        }
        this.setPipeline();
        this.setExecutionId();
        if (type.equals("stage")) {
            this.setStageName();
            this.setStageIndex();
        }
    }

    private void setRepo() throws FieldNotFoundException {
        Map trigger = Optional.ofNullable(this.event.getContent()).map(content -> (Map)content.get("execution")).map(execution -> (Map)execution.get("trigger")).orElseThrow(FieldNotFoundException::new);
        if (trigger.containsKey("type") && "git".equals(trigger.get("type")) && "github".equals(trigger.get("source"))) {
            String repo_project = Optional.ofNullable((String)trigger.get("project")).orElseThrow(FieldNotFoundException::new);
            String repo_slug = Optional.ofNullable((String)trigger.get("slug")).orElseThrow(FieldNotFoundException::new);
            this.repo = String.format("%s/%s", repo_project, repo_slug);
        } else {
            this.repo = Optional.ofNullable(trigger).map(t -> (Map)t.get("buildInfo")).map(buildInfo -> (String)buildInfo.get("name")).orElseThrow(FieldNotFoundException::new);
        }
    }

    private void setSha() throws FieldNotFoundException {
        Map trigger = Optional.ofNullable(this.event.getContent()).map(content -> (Map)content.get("execution")).map(execution -> (Map)execution.get("trigger")).orElseThrow(() -> new FieldNotFoundException("trigger"));
        this.sha = trigger.containsKey("type") && trigger.get("type").equals("git") && trigger.get("source").equals("github") ? Optional.ofNullable((String)trigger.get("hash")).orElseThrow(() -> new FieldNotFoundException("trigger.hash")) : Optional.ofNullable(trigger).map(t -> (Map)t.get("buildInfo")).map(buildInfo -> (List)buildInfo.get("scm")).map(scm -> (Map)scm.get(0)).map(scm -> (String)scm.get("sha1")).orElseThrow(() -> new FieldNotFoundException("trigger.buildInfo.scm[0].sha1"));
    }

    private void setPipeline() throws FieldNotFoundException {
        this.pipeline = Optional.ofNullable(this.event.getContent()).map(content -> (Map)content.get("execution")).map(execution -> (String)execution.get("name")).orElseThrow(() -> new FieldNotFoundException("execution.name"));
    }

    private void setStageName() throws FieldNotFoundException {
        String stageName = Optional.ofNullable(this.event.getContent()).map(content -> (String)content.get("name")).orElse(null);
        if (stageName == null) {
            stageName = Optional.ofNullable(this.event.getContent()).map(content -> (Map)content.get("context")).map(context -> (Map)context.get("stageDetails")).map(stageDetails -> (String)stageDetails.get("name")).orElseThrow(() -> new FieldNotFoundException("context.stageDetails.name"));
        }
        this.stageName = stageName;
    }

    private void setStageIndex() throws FieldNotFoundException {
        List stages = Optional.ofNullable(this.event.getContent()).map(content -> (Map)content.get("execution")).map(execution -> (List)execution.get("stages")).orElseThrow(() -> new FieldNotFoundException("execution.stages"));
        Map stage = stages.stream().filter(s -> s.get("name").equals(this.getStageName())).findFirst().orElseThrow(() -> new FieldNotFoundException("execution.stages.name"));
        this.stageIndex = stages.indexOf(stage);
    }

    private void setExecutionId() throws FieldNotFoundException {
        this.executionId = Optional.ofNullable(this.event.getContent()).map(content -> (Map)content.get("execution")).map(execution -> (String)execution.get("id")).orElseThrow(() -> new FieldNotFoundException("execution.id"));
    }

    public String getRepo() {
        return this.repo;
    }

    public String getSha() {
        return this.sha;
    }

    public String getPipeline() {
        return this.pipeline;
    }

    public String getStageName() {
        return this.stageName;
    }

    public int getStageIndex() {
        return this.stageIndex;
    }

    public String getExecutionId() {
        return this.executionId;
    }
}

