/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.echo.notification;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.echo.api.events.Event;
import com.netflix.spinnaker.echo.config.DryRunConfig;
import com.netflix.spinnaker.echo.jackson.EchoObjectMapper;
import com.netflix.spinnaker.echo.model.Pipeline;
import com.netflix.spinnaker.echo.model.Trigger;
import com.netflix.spinnaker.echo.notification.AbstractEventNotificationAgent;
import com.netflix.spinnaker.echo.pipelinetriggers.orca.OrcaService;
import com.netflix.spinnaker.echo.services.Front50Service;
import com.netflix.spinnaker.kork.retrofit.Retrofit2SyncCall;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;

public class DryRunNotificationAgent
extends AbstractEventNotificationAgent {
    private static final Logger log = LoggerFactory.getLogger(DryRunNotificationAgent.class);
    private final Front50Service front50;
    private final OrcaService orca;
    private final DryRunConfig.DryRunProperties properties;
    private final ObjectMapper mapper = EchoObjectMapper.getInstance();

    public DryRunNotificationAgent(Front50Service front50, OrcaService orca, DryRunConfig.DryRunProperties properties) {
        this.front50 = front50;
        this.orca = orca;
        this.properties = properties;
    }

    public String getNotificationType() {
        return "dryrun";
    }

    public void sendNotifications(Map<String, Object> preference, String application, Event event, Map<String, String> config, String status) {
        Map execution = (Map)event.getContent().get("execution");
        String pipelineConfigId = (String)execution.get("pipelineConfigId");
        if (pipelineConfigId == null) {
            return;
        }
        log.info("Received dry run notification for {}", (Object)pipelineConfigId);
        Optional<Pipeline> match = ((List)Retrofit2SyncCall.execute((Call)this.front50.getPipelines(application))).stream().filter(pipeline -> pipeline.getId().equals(pipelineConfigId)).findFirst();
        if (!match.isPresent()) {
            log.error("No pipeline with config id {} found for {}", (Object)pipelineConfigId, (Object)application);
            return;
        }
        try {
            Pipeline pipeline2 = match.get();
            log.warn("Triggering dry run of {} {}", (Object)pipeline2.getApplication(), (Object)pipeline2.getName());
            Trigger trigger = Trigger.builder().type(Trigger.Type.DRYRUN.toString()).lastSuccessfulExecution(execution).build();
            OrcaService.TriggerResponse response = (OrcaService.TriggerResponse)Retrofit2SyncCall.execute((Call)this.orca.trigger(pipeline2.withName(String.format("%s (dry run)", pipeline2.getName())).withId(null).withTrigger(trigger).withNotifications((List)this.mapper.convertValue(this.properties.getNotifications(), List.class))));
            log.info("Pipeline triggered: {}", (Object)response);
        }
        catch (Exception ex) {
            log.error("Error triggering dry run of {}", (Object)pipelineConfigId, (Object)ex);
        }
    }
}

