/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.echo.microsoftteams.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.netflix.spinnaker.echo.api.Notification;
import com.netflix.spinnaker.echo.microsoftteams.api.MicrosoftTeamsPotentialActionChoice;
import com.netflix.spinnaker.echo.microsoftteams.api.MicrosoftTeamsPotentialActionTarget;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MicrosoftTeamsPotentialAction {
    private static final Logger log = LoggerFactory.getLogger(MicrosoftTeamsPotentialAction.class);
    private static String ACTION_NAME_SINGLE_ACTION = "View Execution";
    private static String ACTION_NAME_MULTI_ACTION = "Choose an option below";
    private static String ACTION_TYPE_OPEN_URI = "OpenUri";
    private static String ACTION_TYPE_MULTI_CHOICE_INPUT = "ActionCard";
    @JsonProperty(value="@type")
    public String type;
    public String name = ACTION_NAME_SINGLE_ACTION;
    public List<MicrosoftTeamsPotentialActionTarget> targets;
    public boolean isMultiSelect = false;
    public List<MicrosoftTeamsPotentialActionChoice> actions;

    @JsonIgnore
    public void setMultiChoiceAction(List<Notification.InteractiveAction> interactiveActions) {
        log.debug("Setting Teams multi choice action");
        this.name = ACTION_NAME_MULTI_ACTION;
        this.type = ACTION_TYPE_MULTI_CHOICE_INPUT;
        this.actions = new ArrayList<MicrosoftTeamsPotentialActionChoice>();
        for (Notification.InteractiveAction action : interactiveActions) {
            this.actions.add(new MicrosoftTeamsPotentialActionChoice(action.getName(), action.getValue()));
        }
    }

    @JsonIgnore
    public void setSingleChoiceAction(String url) {
        log.debug("Setting Teams single choice action");
        this.targets = new ArrayList<MicrosoftTeamsPotentialActionTarget>();
        this.type = ACTION_TYPE_OPEN_URI;
        this.targets.add(new MicrosoftTeamsPotentialActionTarget(url));
    }
}

