/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.echo.microsoftteams;

import com.netflix.spinnaker.config.OkHttp3ClientConfiguration;
import com.netflix.spinnaker.echo.microsoftteams.MicrosoftTeamsClient;
import com.netflix.spinnaker.echo.microsoftteams.MicrosoftTeamsMessage;
import com.netflix.spinnaker.kork.retrofit.ErrorHandlingExecutorCallAdapterFactory;
import com.netflix.spinnaker.kork.retrofit.Retrofit2SyncCall;
import com.netflix.spinnaker.kork.retrofit.util.RetrofitUtils;
import com.netflix.spinnaker.kork.web.exceptions.InvalidRequestException;
import java.net.MalformedURLException;
import java.net.URL;
import okhttp3.ResponseBody;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class MicrosoftTeamsService {
    private static final Logger log = LoggerFactory.getLogger(MicrosoftTeamsService.class);
    private final OkHttp3ClientConfiguration okHttp3ClientConfiguration;

    public MicrosoftTeamsService(OkHttp3ClientConfiguration okHttp3ClientConfiguration) {
        this.okHttp3ClientConfiguration = okHttp3ClientConfiguration;
    }

    public ResponseBody sendMessage(String webhookUrl, MicrosoftTeamsMessage message) {
        MicrosoftTeamsClient microsoftTeamsClient = (MicrosoftTeamsClient)new Retrofit.Builder().baseUrl(RetrofitUtils.getBaseUrl((String)webhookUrl)).client(this.okHttp3ClientConfiguration.createForRetrofit2().build()).addCallAdapterFactory((CallAdapter.Factory)ErrorHandlingExecutorCallAdapterFactory.getInstance()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).build().create(MicrosoftTeamsClient.class);
        return (ResponseBody)Retrofit2SyncCall.execute(microsoftTeamsClient.sendMessage(this.getRelativePath(webhookUrl), message));
    }

    private String getRelativePath(String webhookUrl) {
        String relativePath = "";
        try {
            URL url = new URL(webhookUrl);
            relativePath = url.getPath();
            if (StringUtils.isEmpty((CharSequence)relativePath)) {
                throw new MalformedURLException();
            }
        }
        catch (MalformedURLException e) {
            throw new InvalidRequestException("Unable to determine relative path from Microsoft Teams webhook URL.", (Throwable)e);
        }
        if (relativePath.charAt(0) == '/') {
            relativePath = relativePath.substring(1);
        }
        return relativePath;
    }
}

