/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.echo.microsoftteams;

import com.netflix.spinnaker.echo.api.Notification;
import com.netflix.spinnaker.echo.controller.EchoResponse;
import com.netflix.spinnaker.echo.microsoftteams.MicrosoftTeamsMessage;
import com.netflix.spinnaker.echo.microsoftteams.MicrosoftTeamsService;
import com.netflix.spinnaker.echo.microsoftteams.api.MicrosoftTeamsSection;
import com.netflix.spinnaker.echo.notification.NotificationService;
import com.netflix.spinnaker.echo.notification.NotificationTemplateEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"microsoftteams.enabled"})
class MicrosoftTeamsNotificationService
implements NotificationService {
    private static final Logger log = LoggerFactory.getLogger(MicrosoftTeamsNotificationService.class);
    private final MicrosoftTeamsService teamsService;
    private final NotificationTemplateEngine notificationTemplateEngine;
    @Value(value="${spinnaker.base-url}")
    private String spinnakerUrl;

    @Autowired
    public MicrosoftTeamsNotificationService(MicrosoftTeamsService service, NotificationTemplateEngine engine) {
        this.teamsService = service;
        this.notificationTemplateEngine = engine;
    }

    @Override
    public boolean supportsType(String type) {
        return "MICROSOFTTEAMS".equals(type.toUpperCase());
    }

    @Override
    public EchoResponse.Void handle(Notification notification) {
        log.info("Building Microsoft Teams event notification");
        String link = this.spinnakerUrl + "/#/applications/" + notification.getSource().getApplication() + "/executions/details/" + notification.getSource().getExecutionId();
        String message = this.notificationTemplateEngine.build(notification, NotificationTemplateEngine.Type.SUBJECT);
        String summary = this.notificationTemplateEngine.build(notification, NotificationTemplateEngine.Type.BODY);
        MicrosoftTeamsMessage teamsMessage = new MicrosoftTeamsMessage(summary, null);
        MicrosoftTeamsSection section = teamsMessage.createSection(null, "Event Notification");
        section.setMessage(message);
        section.setSummary(summary);
        if (notification.getAdditionalContext().get("stageId") != null) {
            link = link + "?refId=" + String.valueOf(notification.getAdditionalContext().get("stageId"));
            if (notification.getAdditionalContext().get("restrictExecutionDuringTimeWindow") != null) {
                link = link + "&step=1";
            }
        }
        if (notification.isInteractive()) {
            log.info("Notification is interactive");
            section.setPotentialAction(null, notification.getInteractiveActions());
        } else {
            section.setPotentialAction(link, null);
        }
        teamsMessage.addSection(section);
        for (String webhookUrl : notification.getTo()) {
            log.info("Sending Microsoft Teams event notification");
            log.debug("Teams Webhook URL: {}", (Object)webhookUrl);
            this.teamsService.sendMessage(webhookUrl, teamsMessage);
        }
        return new EchoResponse.Void();
    }
}

