/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.echo.microsoftteams;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.netflix.spinnaker.echo.microsoftteams.api.MicrosoftTeamsSection;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class MicrosoftTeamsMessage {
    private static String MESSAGE_CARD_CONTEXT = "http://schema.org/extensions";
    private static String MESSAGE_CARD_TITLE = "Spinnaker Notification";
    private static String MESSAGE_CARD_TYPE = "MessageCard";
    @JsonProperty(value="@context")
    public String context = MESSAGE_CARD_CONTEXT;
    @JsonProperty(value="@type")
    public String type;
    public String correlationId = this.createRandomUUID();
    public List<MicrosoftTeamsSection> sections;
    public String summary;
    public String themeColor;
    public String title;
    private transient String customMessage;
    private transient String status;

    public MicrosoftTeamsMessage(String summary, String status) {
        this.status = status;
        this.summary = summary;
        this.title = MESSAGE_CARD_TITLE;
        this.type = MESSAGE_CARD_TYPE;
        this.sections = new ArrayList<MicrosoftTeamsSection>();
        this.themeColor = this.getThemeColor(status);
    }

    @JsonIgnore
    public MicrosoftTeamsSection createSection(String executionType, String title) {
        return new MicrosoftTeamsSection(executionType, title);
    }

    @JsonIgnore
    public void addSection(MicrosoftTeamsSection section) {
        this.sections.add(section);
    }

    private String getThemeColor(String status) {
        String color = "";
        String string = status = status == null ? "" : status;
        color = status.contains("failed") ? "EB1A1A" : (status.contains("complete") ? "73DB69" : "0076D7");
        return color;
    }

    private String createRandomUUID() {
        return UUID.randomUUID().toString();
    }
}

