/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.echo.googlechat;

import com.netflix.spinnaker.echo.googlechat.GoogleChatClient;
import com.netflix.spinnaker.echo.googlechat.GoogleChatMessage;
import com.netflix.spinnaker.kork.retrofit.Retrofit2SyncCall;
import groovy.transform.Canonical;
import okhttp3.ResponseBody;

@Canonical
public class GoogleChatService {
    GoogleChatClient googleChatClient;

    public GoogleChatService(GoogleChatClient googleChatClient) {
        this.googleChatClient = googleChatClient;
    }

    ResponseBody sendMessage(String webhook, GoogleChatMessage message) {
        WebhookUrlParts parts = this.extractWebhookUrlParts(webhook);
        return (ResponseBody)Retrofit2SyncCall.execute(this.googleChatClient.sendMessage(parts.getSpaceId(), parts.getKey(), parts.getToken(), message));
    }

    private WebhookUrlParts extractWebhookUrlParts(String partialWebhookURL) {
        String[] parts = partialWebhookURL.split("\\?");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Invalid Google Chat webhook URL format");
        }
        String[] queryParams = parts[1].split("&");
        String key = "";
        String token = "";
        for (String param : queryParams) {
            String[] keyValue = param.split("=");
            if (keyValue.length != 2) continue;
            if ("key".equals(keyValue[0])) {
                key = keyValue[1];
                continue;
            }
            if (!"token".equals(keyValue[0])) continue;
            token = keyValue[1];
        }
        return new WebhookUrlParts(parts[0], key, token);
    }

    private static class WebhookUrlParts {
        private final String spaceId;
        private final String key;
        private final String token;

        public String getSpaceId() {
            return this.spaceId;
        }

        public String getKey() {
            return this.key;
        }

        public String getToken() {
            return this.token;
        }

        public WebhookUrlParts(String spaceId, String key, String token) {
            this.spaceId = spaceId;
            this.key = key;
            this.token = token;
        }
    }
}

