/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.echo.googlechat;

import com.netflix.spinnaker.echo.api.Notification;
import com.netflix.spinnaker.echo.controller.EchoResponse;
import com.netflix.spinnaker.echo.googlechat.GoogleChatMessage;
import com.netflix.spinnaker.echo.googlechat.GoogleChatService;
import com.netflix.spinnaker.echo.notification.NotificationService;
import com.netflix.spinnaker.echo.notification.NotificationTemplateEngine;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"googlechat.enabled"})
class GoogleChatNotificationService
implements NotificationService {
    @Autowired
    GoogleChatService chat;
    @Autowired
    NotificationTemplateEngine notificationTemplateEngine;

    GoogleChatNotificationService() {
    }

    @Override
    public boolean supportsType(String type) {
        return "GOOGLECHAT".equals(type.toUpperCase());
    }

    @Override
    public EchoResponse.Void handle(Notification notification) {
        String body = this.notificationTemplateEngine.build(notification, NotificationTemplateEngine.Type.BODY);
        Collection<String> addressSet = notification.getTo();
        for (String addr : addressSet) {
            String baseUrl = "https://chat.googleapis.com/v1/spaces/";
            String completeLink = addr;
            String partialWebhookURL = completeLink.substring(baseUrl.length());
            this.chat.sendMessage(partialWebhookURL, new GoogleChatMessage(body));
        }
        return new EchoResponse.Void();
    }
}

