/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.echo.config;

import com.netflix.spinnaker.config.OkHttp3ClientConfiguration;
import com.netflix.spinnaker.echo.config.SlackAppProperties;
import com.netflix.spinnaker.echo.config.SlackLegacyProperties;
import com.netflix.spinnaker.echo.slack.SlackAppService;
import com.netflix.spinnaker.echo.slack.SlackClient;
import com.netflix.spinnaker.echo.slack.SlackService;
import com.netflix.spinnaker.kork.retrofit.ErrorHandlingExecutorCallAdapterFactory;
import com.netflix.spinnaker.kork.retrofit.util.RetrofitUtils;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

@Configuration
@ConditionalOnProperty(value={"slack.enabled"})
@EnableConfigurationProperties(value={SlackLegacyProperties.class, SlackAppProperties.class})
public class SlackConfig
implements GroovyObject {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public SlackConfig() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Bean
    @Qualifier(value="slackLegacyService")
    public SlackService slackService(@Qualifier(value="slackLegacyConfig") SlackLegacyProperties config, OkHttp3ClientConfiguration okHttpClientConfig) {
        if (log.isInfoEnabled()) {
            log.info("Using Slack {}: {}.", (Object)(config.getUseIncomingWebhook() ? "incoming webhook" : "chat api"), (Object)config.getBaseUrl());
            v0 = null;
        } else {
            v0 = null;
        }
        CallSite slackClient = IndyInterface.bootstrap("cast", "()", 0, new Retrofit.Builder().baseUrl(RetrofitUtils.getBaseUrl((String)config.getBaseUrl())).client(okHttpClientConfig.createForRetrofit2().build()).addCallAdapterFactory((CallAdapter.Factory)ErrorHandlingExecutorCallAdapterFactory.getInstance()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).build().create(SlackClient.class));
        log.info("Slack legacy service loaded");
        return new SlackService((SlackClient)((Object)slackClient), config);
    }

    @Bean
    @Qualifier(value="slackAppService")
    public SlackAppService slackAppService(@Qualifier(value="slackAppConfig") SlackAppProperties config, OkHttp3ClientConfiguration okHttpClientConfig) {
        CallSite slackClient = IndyInterface.bootstrap("cast", "()", 0, new Retrofit.Builder().baseUrl(RetrofitUtils.getBaseUrl((String)config.getBaseUrl())).client(okHttpClientConfig.createForRetrofit2().build()).addCallAdapterFactory((CallAdapter.Factory)ErrorHandlingExecutorCallAdapterFactory.getInstance()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).build().create(SlackClient.class));
        log.info("Slack app service loaded");
        return new SlackAppService((SlackClient)((Object)slackClient), config);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != SlackConfig.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"com.netflix.spinnaker.echo.config.SlackConfig");
    }
}

